/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.operators.LogicalOperator;
import net.sf.jdmf.data.output.AbstractRuleElementEvaluable;
import net.sf.jdmf.data.output.RuleElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Rule
extends AbstractRuleElementEvaluable {
    private static Log log = LogFactory.getLog(Rule.class);
    private List<RuleElement> conditions = new ArrayList<RuleElement>();
    private List<RuleElement> consequences = new ArrayList<RuleElement>();

    @Override
    public boolean evaluate(Instance instance) {
        log.debug((Object)("conditions: " + this.conditions.toString()));
        log.debug((Object)("consequences: " + this.consequences.toString()));
        return this.evaluateRuleElements(this.conditions, instance) && this.evaluateRuleElements(this.consequences, instance);
    }

    public RuleElement defineIf() {
        this.conditions.clear();
        RuleElement condition = new RuleElement();
        this.conditions.add(condition);
        return condition;
    }

    public RuleElement defineThen() {
        this.consequences.clear();
        RuleElement consequence = new RuleElement();
        this.consequences.add(consequence);
        return consequence;
    }

    public RuleElement getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public RuleElement getLastConsequence() {
        return this.consequences.get(this.consequences.size() - 1);
    }

    public void merge(Rule rule) {
        List<RuleElement> consequencesBeingMerged;
        List<RuleElement> conditionsBeingMerged = rule.getConditions();
        if (!conditionsBeingMerged.isEmpty()) {
            RuleElement firstMergedElement = new RuleElement(conditionsBeingMerged.get(0).getItem(), LogicalOperator.AND);
            Iterator<RuleElement> subElementsIterator = conditionsBeingMerged.get(0).subElementsIterator();
            while (subElementsIterator.hasNext()) {
                firstMergedElement.addSubElement(subElementsIterator.next());
            }
            int firstMergedElementIndex = this.conditions.size();
            this.conditions.addAll(conditionsBeingMerged);
            this.conditions.set(firstMergedElementIndex, firstMergedElement);
        }
        if (!(consequencesBeingMerged = rule.getConsequences()).isEmpty()) {
            RuleElement firstMergedElement = new RuleElement(consequencesBeingMerged.get(0).getItem(), LogicalOperator.AND);
            Iterator<RuleElement> subElementsIterator = consequencesBeingMerged.get(0).subElementsIterator();
            while (subElementsIterator.hasNext()) {
                firstMergedElement.addSubElement(subElementsIterator.next());
            }
            int firstMergedElementIndex = this.consequences.size();
            this.consequences.addAll(consequencesBeingMerged);
            this.consequences.set(firstMergedElementIndex, firstMergedElement);
        }
    }

    public void addCondition(RuleElement condition) {
        this.conditions.add(condition);
    }

    public void addConsequence(RuleElement consequence) {
        this.consequences.add(consequence);
    }

    public String toString() {
        String output = "IF ";
        output = output + this.conditions.toString();
        output = output + " THEN ";
        output = output + this.consequences.toString();
        output = output + "\n";
        return output;
    }

    public List<RuleElement> getConditions() {
        return this.conditions;
    }

    public List<RuleElement> getConsequences() {
        return this.consequences;
    }

    public void setConditions(List<RuleElement> conditions) {
        this.conditions = conditions;
    }

    public void setConsequences(List<RuleElement> consequences) {
        this.consequences = consequences;
    }
}

