/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.output;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.operators.EqualityOperator;
import net.sf.jdmf.data.operators.LogicalOperator;
import net.sf.jdmf.data.output.AbstractRuleElementEvaluable;
import net.sf.jdmf.data.output.Item;
import net.sf.jdmf.data.output.Rule;
import net.sf.jdmf.data.output.RuleDefinitionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleElement
extends AbstractRuleElementEvaluable {
    private static Log log = LogFactory.getLog(RuleElement.class);
    private Item item;
    private LogicalOperator logicalOperator;
    private List<RuleElement> subElements = new ArrayList<RuleElement>();

    public RuleElement() {
    }

    public RuleElement(Item item) {
        this.item = item;
    }

    public RuleElement(Item item, LogicalOperator logicalOperator) {
        this.item = item;
        this.logicalOperator = logicalOperator;
    }

    @Override
    public boolean evaluate(Instance instance) {
        if (this.subElements.isEmpty()) {
            log.debug((Object)("item: " + this.item));
            return this.item.evaluate(instance);
        }
        log.debug((Object)("subElements: " + this.subElements));
        return this.evaluateRuleElements(this.subElements, instance);
    }

    public RuleElement attribute(String attributeName) {
        this.item = new Item();
        this.item.setAttributeName(attributeName);
        return this;
    }

    public RuleElement equals(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.EQUAL);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement doesNotEqual(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.NOT_EQUAL);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement isGreaterThan(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.GREATER_THAN);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement isGreaterThanOrEqualTo(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.GREATER_THAN_OR_EQUAL);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement isLowerThan(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.LOWER_THAN);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement isLowerThanOrEqualTo(Comparable attributeValue) {
        this.item.setEqualityOperator(EqualityOperator.LOWER_THAN_OR_EQUAL);
        this.item.setAttributeValue(attributeValue);
        return this;
    }

    public RuleElement and(Rule parentRule) {
        RuleElement ruleElement = this.classifyRuleElement(parentRule);
        ruleElement.setLogicalOperator(LogicalOperator.AND);
        return ruleElement;
    }

    public RuleElement or(Rule parentRule) {
        RuleElement ruleElement = this.classifyRuleElement(parentRule);
        ruleElement.setLogicalOperator(LogicalOperator.OR);
        return ruleElement;
    }

    public RuleElement xor(Rule parentRule) {
        RuleElement ruleElement = this.classifyRuleElement(parentRule);
        ruleElement.setLogicalOperator(LogicalOperator.XOR);
        return ruleElement;
    }

    protected RuleElement classifyRuleElement(Rule parentRule) {
        List<RuleElement> conditions = parentRule.getConditions();
        List<RuleElement> consequences = parentRule.getConsequences();
        RuleElement ruleElement = new RuleElement();
        if (conditions.contains(this) && conditions.indexOf(this) == conditions.size() - 1) {
            conditions.add(ruleElement);
        } else if (consequences.contains(this) && consequences.indexOf(this) == consequences.size() - 1) {
            consequences.add(ruleElement);
        } else {
            throw new RuleDefinitionException("Could not define rule - the previous rule element is not defined");
        }
        return ruleElement;
    }

    public boolean equals(Object obj) {
        RuleElement ruleElement = (RuleElement)obj;
        return this.item.equals(ruleElement.item) && this.subElements.equals(ruleElement.subElements);
    }

    public String toString() {
        String output = "";
        if (this.logicalOperator != null) {
            output = output + " ";
            output = output + this.logicalOperator.toString();
            output = output + " ";
        }
        if (this.item != null) {
            output = output + this.item.toString();
        } else {
            output = output + "( ";
            for (RuleElement subElement : this.subElements) {
                output = output + subElement.toString();
            }
            output = output + " )";
        }
        return output;
    }

    public void addSubElement(RuleElement subElement) {
        this.subElements.add(subElement);
    }

    public Iterator<RuleElement> subElementsIterator() {
        return this.subElements.iterator();
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator;
    }
}

