/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.sources.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jdmf.data.sources.DataSource;
import net.sf.jdmf.data.sources.DataSourceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDataSource
implements DataSource {
    private static Log log = LogFactory.getLog(JDBCDataSource.class);
    private String connectionString;
    private String userName;
    private String password;
    private List<String> queries = new ArrayList<String>();

    public JDBCDataSource(Driver driver, String connectionString, String userName, String password, String query) {
        this.connectionString = connectionString;
        this.userName = userName;
        this.password = password;
        this.queries.add(query);
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not register JDBC driver", e);
        }
    }

    public JDBCDataSource(Driver driver, String connectionString, String userName, String password, List<String> queries) {
        this(driver, connectionString, userName, password, queries.get(0));
        for (int i = 1; i < queries.size(); ++i) {
            this.queries.add(queries.get(i));
        }
    }

    @Override
    public Map<String, List<Comparable>> getAttributes() {
        LinkedHashMap<String, List<Comparable>> attributes = new LinkedHashMap<String, List<Comparable>>();
        try {
            Connection connection = DriverManager.getConnection(this.connectionString, this.userName, this.password);
            Statement statement = connection.createStatement();
            for (String query : this.queries) {
                int i;
                ResultSet resultSet = statement.executeQuery(query);
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (i = 1; i <= columnCount; ++i) {
                    String attributeName = metaData.getColumnName(i);
                    ArrayList attributeValues = new ArrayList();
                    attributes.put(attributeName, attributeValues);
                }
                while (resultSet.next()) {
                    for (i = 1; i <= columnCount; ++i) {
                        List attributeValues = (List)attributes.get(metaData.getColumnName(i));
                        attributeValues.add(this.getValueAsComparable(resultSet.getObject(i)));
                    }
                }
                resultSet.close();
            }
            statement.close();
            connection.close();
        }
        catch (SQLException e) {
            throw new DataSourceException("Could not retrieve data", e);
        }
        return attributes;
    }

    protected Comparable getValueAsComparable(Object value) {
        Object comparable = null;
        if (value instanceof Double || value instanceof Integer || value instanceof BigDecimal) {
            comparable = Double.parseDouble(value.toString());
        } else if (value instanceof String) {
            comparable = value.toString();
        } else if (value instanceof Boolean) {
            comparable = Boolean.parseBoolean(value.toString());
        } else if (value instanceof Date) {
            comparable = new Date(((Date)value).getTime());
        } else {
            log.debug((Object)("Unhandled value type: " + value.getClass().getName()));
        }
        return comparable;
    }
}

