/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;

public class MathCalculator {
    private static Log log = LogFactory.getLog(MathCalculator.class);

    public Double calculateNormalDistribution(Comparable[] attributeValues, Double x) {
        Double mean = this.calculateMean(attributeValues);
        Double standardDeviation = this.calculateStandardDeviation(attributeValues, mean);
        Double normalDistribution = 1.0 / (Math.sqrt(Math.PI * 2) * standardDeviation);
        normalDistribution = normalDistribution * Math.exp(-Math.pow((x - mean) / standardDeviation, 2.0) / 2.0);
        log.debug((Object)("normalDistribution( " + x + " ) = " + normalDistribution));
        return normalDistribution;
    }

    public Double calculateMean(Comparable[] attributeValues) {
        Mean mean = new Mean();
        Double evaluatedMean = mean.evaluate(this.convertToPrimitives(attributeValues));
        log.debug((Object)("mean = " + evaluatedMean));
        return evaluatedMean;
    }

    public Double calculateStandardDeviation(Comparable[] attributeValues, Double mean) {
        StandardDeviation standardDeviation = new StandardDeviation();
        Double evaluatedStdDev = standardDeviation.evaluate(this.convertToPrimitives(attributeValues), mean.doubleValue());
        log.debug((Object)("standardDeviation( " + mean + " ) = " + evaluatedStdDev));
        return evaluatedStdDev;
    }

    public Double calculateDistance(Vector<Double> firstPoint, Vector<Double> secondPoint) {
        SumOfSquares sumOfSquares = new SumOfSquares();
        for (int i = 0; i < firstPoint.size(); ++i) {
            sumOfSquares.increment(secondPoint.get(i) - firstPoint.get(i));
        }
        return Math.sqrt(sumOfSquares.getResult());
    }

    public Vector<Double> calculateCentroid(List<Vector<Double>> points) {
        ArrayList<Mean> coordinateMeans = new ArrayList<Mean>();
        for (int i = 0; i < points.get(0).size(); ++i) {
            coordinateMeans.add(new Mean());
        }
        for (Vector<Double> point : points) {
            for (int i = 0; i < point.size(); ++i) {
                ((Mean)coordinateMeans.get(i)).increment(point.get(i).doubleValue());
            }
        }
        Vector<Double> centroid = new Vector<Double>();
        for (Mean mean : coordinateMeans) {
            centroid.add(mean.getResult());
        }
        return centroid;
    }

    protected double[] convertToPrimitives(Comparable[] values) {
        double[] primitives = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            primitives[i] = (Double)values[i];
        }
        return primitives;
    }
}

