/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.profile.StatisticalAnalysis;

public class NormalizeCol {
    public static ArrayList<Double> zeroNormal(ArrayList<Number> inputCol) {
        int colLen = inputCol.size();
        Object[] intemediate = new Number[colLen];
        intemediate = inputCol.toArray(intemediate);
        Arrays.sort(intemediate);
        Double min = (Double)intemediate[0];
        Double max = (Double)intemediate[colLen - 1];
        ArrayList<Double> outnormal = new ArrayList<Double>();
        for (Number i : inputCol) {
            Double factor = ((Double)i - min) / (max - min);
            outnormal.add(factor);
        }
        return outnormal;
    }

    public static ReportTableModel zeroNormal(ReportTableModel rtm, int inputIndex, int outPutIndex) {
        Vector<Double> inputData = rtm.getColDataVD(inputIndex);
        int colLen = inputData.size();
        Object[] intemediate = new Number[colLen];
        intemediate = inputData.toArray(intemediate);
        Arrays.sort(intemediate);
        Double min = (Double)intemediate[0];
        Double max = (Double)intemediate[colLen - 1];
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object d = rtm.getModel().getValueAt(i, inputIndex);
            if (d == null) {
                rtm.getModel().setValueAt(d, i, outPutIndex);
                continue;
            }
            Double factor = 0.0;
            if (d instanceof Number) {
                factor = ((Double)d - min) / (max - min);
            } else if (d instanceof String) {
                try {
                    factor = Double.parseDouble(d.toString());
                    factor = (factor - min) / (max - min);
                }
                catch (Exception e) {
                    factor = null;
                }
            }
            rtm.getModel().setValueAt(factor, i, outPutIndex);
        }
        return rtm;
    }

    public static ReportTableModel zscoreNormal(ReportTableModel rtm, int inputIndex, int outPutIndex) {
        Vector<Double> inputData = rtm.getColDataVD(inputIndex);
        StatisticalAnalysis sa = new StatisticalAnalysis(inputData.toArray());
        Double mean = sa.getMean();
        Double sdev = sa.getSDev();
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object d = rtm.getModel().getValueAt(i, inputIndex);
            if (d == null) {
                rtm.getModel().setValueAt(d, i, outPutIndex);
                continue;
            }
            Double factor = 0.0;
            if (d instanceof Number) {
                factor = ((Double)d - mean) / sdev;
            } else if (d instanceof String) {
                try {
                    factor = Double.parseDouble(d.toString());
                    factor = (factor - mean) / sdev;
                }
                catch (Exception e) {
                    factor = null;
                }
            }
            rtm.getModel().setValueAt(factor, i, outPutIndex);
        }
        return rtm;
    }

    public static ReportTableModel meanStdNormal(ReportTableModel rtm, int inputIndex, int outPutIndex, int std) {
        Vector<Double> inputData = rtm.getColDataVD(inputIndex);
        StatisticalAnalysis sa = new StatisticalAnalysis(inputData.toArray());
        Double mean = sa.getMean();
        Double sdev = sa.getSDev();
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object d = rtm.getModel().getValueAt(i, inputIndex);
            if (d == null) {
                rtm.getModel().setValueAt(d, i, outPutIndex);
                continue;
            }
            Double factor = 0.0;
            if (d instanceof Number) {
                factor = std == 0 ? Double.valueOf((Double)d / sdev) : (std == 1 ? Double.valueOf((Double)d / mean) : Double.valueOf((Double)d - mean));
            } else if (d instanceof String) {
                try {
                    factor = Double.parseDouble(d.toString());
                    factor = std == 0 ? Double.valueOf(factor / sdev) : (std == 1 ? Double.valueOf(factor / mean) : Double.valueOf(factor - mean));
                }
                catch (Exception e) {
                    factor = null;
                }
            }
            rtm.getModel().setValueAt(factor, i, outPutIndex);
        }
        return rtm;
    }

    public static ReportTableModel distStdNormal(ReportTableModel rtm, int inputIndex, int outPutIndex) {
        Vector<Double> inputData = rtm.getColDataVD(inputIndex);
        StatisticalAnalysis sa = new StatisticalAnalysis(inputData.toArray());
        Double mean = sa.getMean();
        Double sdev = sa.getSDev();
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object d = rtm.getModel().getValueAt(i, inputIndex);
            if (d == null) {
                rtm.getModel().setValueAt(d, i, outPutIndex);
                continue;
            }
            Double factor = 0.0;
            if (d instanceof Number) {
                factor = ((Double)d - mean) / sdev;
            } else if (d instanceof String) {
                try {
                    factor = Double.parseDouble(d.toString());
                    factor = (factor - mean) / sdev;
                }
                catch (Exception e) {
                    factor = null;
                }
            }
            rtm.getModel().setValueAt(factor, i, outPutIndex);
        }
        return rtm;
    }

    public static ReportTableModel roundingIndex(ReportTableModel rtm, int inputIndex, int outPutIndex, int roundtingType) {
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object d = rtm.getModel().getValueAt(i, inputIndex);
            if (d == null) {
                rtm.getModel().setValueAt(d, i, outPutIndex);
                continue;
            }
            Double factor = 0.0;
            if (d instanceof Number) {
                switch (roundtingType) {
                    case 1: {
                        factor = Math.round((Double)d);
                        break;
                    }
                    case 2: {
                        factor = Math.ceil((Double)d);
                        break;
                    }
                    case 3: {
                        factor = Math.floor((Double)d);
                        break;
                    }
                    case 4: {
                        factor = Math.round((Double)d / 10.0) * 10L;
                        break;
                    }
                }
            } else if (d instanceof String) {
                try {
                    d = Double.parseDouble(d.toString());
                    switch (roundtingType) {
                        case 1: {
                            factor = Math.round((Double)d);
                            break;
                        }
                        case 2: {
                            factor = Math.ceil((Double)d);
                            break;
                        }
                        case 3: {
                            factor = Math.floor((Double)d);
                            break;
                        }
                        case 4: {
                            factor = Math.round((Double)d / 10.0) * 10L;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception:" + e.getLocalizedMessage());
                    factor = null;
                }
            }
            rtm.getModel().setValueAt(factor, i, outPutIndex);
        }
        return rtm;
    }
}

