/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.Arrays;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.profile.StatisticalAnalysis;

public class AggrCumRTM {
    public static double getSum(Vector<Double> colList) {
        double sum = 0.0;
        if (colList == null || colList.size() == 0) {
            return sum;
        }
        for (double colVal : colList) {
            sum += colVal;
        }
        return sum;
    }

    public static double getAverage(Vector<Double> colList) {
        if (colList == null || colList.size() == 0) {
            return 0.0;
        }
        long count = colList.size();
        double sum = AggrCumRTM.getSum(colList);
        if (sum != 0.0 && count != 0L) {
            return sum / (double)count;
        }
        return sum;
    }

    public static double[] getMinMax(Vector<Double> colList) {
        double[] minMax = new double[]{0.0, 0.0};
        if (colList == null || colList.size() == 0) {
            return minMax;
        }
        double sum = AggrCumRTM.getSum(colList);
        long count = colList.size();
        if (sum == 0.0 || count == 0L) {
            return minMax;
        }
        Object[] newList = new Double[colList.size()];
        newList = colList.toArray(newList);
        Arrays.sort(newList);
        minMax[0] = (Double)newList[0];
        minMax[1] = (Double)newList[newList.length - 1];
        return minMax;
    }

    public static Vector<Double> getCumSum(Vector<Double> colList) {
        if (colList == null || colList.size() == 0) {
            return colList;
        }
        Vector<Double> cumSum = new Vector<Double>();
        double csum = 0.0;
        for (double colVal : colList) {
            cumSum.add(csum += colVal);
        }
        return cumSum;
    }

    public static Vector<Double> getCumAvg(Vector<Double> colList) {
        if (colList == null || colList.size() == 0) {
            return colList;
        }
        long count = colList.size();
        Vector<Double> cumAvg = new Vector<Double>();
        double csum = 0.0;
        int i = 1;
        while ((long)i <= count) {
            cumAvg.add((csum += colList.get(i - 1).doubleValue()) / (double)i);
            ++i;
        }
        return cumAvg;
    }

    public static Vector<Double> putNextVal(Vector<Double> colList) {
        if (colList == null || colList.size() == 0) {
            return colList;
        }
        long count = colList.size();
        Vector<Double> nextVal = new Vector<Double>();
        int i = 0;
        while ((long)i < count - 1L) {
            nextVal.add(colList.get(i + 1));
            ++i;
        }
        nextVal.add(0.0);
        return nextVal;
    }

    public static Vector<Double> putPrevVal(Vector<Double> colList) {
        if (colList == null || colList.size() == 0) {
            return colList;
        }
        long count = colList.size();
        Vector<Double> prevVal = new Vector<Double>();
        prevVal.add(0.0);
        int i = 1;
        while ((long)i < count) {
            prevVal.add(colList.get(i - 1));
            ++i;
        }
        return prevVal;
    }

    public static Double getPCorrelation(Vector<Double> one, Vector<Double> two) {
        int rowC_two;
        StatisticalAnalysis sa_1 = new StatisticalAnalysis(one.toArray());
        Double mean_1 = sa_1.getMean();
        StatisticalAnalysis sa_2 = new StatisticalAnalysis(two.toArray());
        Double mean_2 = sa_2.getMean();
        double num = 0.0;
        double denum_a = 0.0;
        double denum_b = 0.0;
        int rowC_one = one.size();
        int rowC = rowC_one > (rowC_two = two.size()) ? rowC_two : rowC_one;
        for (int i = 0; i < rowC; ++i) {
            double a = one.get(i) - mean_1;
            double b = two.get(i) - mean_2;
            num += a * b;
            denum_a += a * a;
            denum_b += b * b;
        }
        return num / (Math.sqrt(denum_a) * Math.sqrt(denum_b));
    }

    public static Vector<Double> getColumnNumberData(ReportTableModel rpt, int columnIndex) {
        Vector<Double> columnDataVector = new Vector<Double>();
        int rowCount = rpt.getModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object obj = rpt.getModel().getValueAt(i, columnIndex);
            if (obj == null) {
                columnDataVector.add(0.0);
            }
            try {
                Double d = Double.parseDouble(obj.toString());
                columnDataVector.add(d);
                continue;
            }
            catch (Exception e) {
                columnDataVector.add(0.0);
            }
        }
        return columnDataVector;
    }
}

