/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.Date;
import org.arrah.framework.datagen.ShuffleRTM;
import org.arrah.framework.ndtable.ReportTableModel;

public class SplitRTM {
    public ReportTableModel[] splitRandom(ReportTableModel rtm, int[] splitperc) {
        int rowc = rtm.getModel().getRowCount();
        int colc = rtm.getModel().getColumnCount();
        int[] colIndex = new int[colc];
        for (int i = 0; i < colc; ++i) {
            colIndex[i] = i;
        }
        rtm = ShuffleRTM.shuffleColumns(rtm, colIndex, 0, rowc);
        int sampleno = splitperc.length;
        int[] splitvalue = new int[sampleno];
        for (int i = 0; i < splitvalue.length; ++i) {
            int buckno = (int)Math.floor(splitperc[i] * rowc / 100);
            splitvalue[i] = i == 0 ? buckno : splitvalue[i - 1] + buckno;
        }
        ReportTableModel[] rtmsplit = new ReportTableModel[sampleno];
        int rowindex = 0;
        for (int i = 0; i < sampleno; ++i) {
            rtmsplit[i] = new ReportTableModel(rtm.getAllColName(), true, true);
            while (rowindex < rowc && rowindex != splitvalue[i]) {
                rtmsplit[i].addFillRow(rtm.getRow(rowindex));
                ++rowindex;
            }
        }
        return rtmsplit;
    }

    public ReportTableModel[] splitByDate(ReportTableModel rtm, int dateCol, Date[] splitdate) {
        int i;
        int rowc = rtm.getModel().getRowCount();
        int splitc = splitdate.length;
        ReportTableModel[] rtmsplit = new ReportTableModel[splitc + 1];
        for (i = 0; i < splitc + 1; ++i) {
            rtmsplit[i] = new ReportTableModel(rtm.getAllColName(), true, true);
        }
        for (i = 0; i < rowc; ++i) {
            Object o = rtm.getModel().getValueAt(i, dateCol);
            boolean outbound = true;
            if (o == null) continue;
            try {
                for (int j = 0; j < splitc; ++j) {
                    if (!((Date)o).before(splitdate[j])) continue;
                    rtmsplit[j].addFillRow(rtm.getRow(i));
                    outbound = false;
                    break;
                }
                if (!outbound) continue;
                rtmsplit[splitc].addFillRow(rtm.getRow(i));
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception:" + e.getLocalizedMessage());
            }
        }
        return rtmsplit;
    }
}

