/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.ndtable;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.arrah.framework.dataquality.SimilarityCheckLucene;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.DataDictionaryPDF;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYSeries;

public class RTMUtil {
    public static ReportTableModel joinTables(ReportTableModel leftT, int indexL, ReportTableModel rightT, int indexR, int joinType) {
        int i;
        int i2;
        Vector<Object> lvc = new Vector<Object>();
        Vector<Object> rvc = new Vector<Object>();
        int lrow_c = leftT.getModel().getRowCount();
        int rrow_c = rightT.getModel().getRowCount();
        for (i2 = 0; i2 < lrow_c; ++i2) {
            lvc.addElement(leftT.getModel().getValueAt(i2, indexL));
        }
        for (i2 = 0; i2 < rrow_c; ++i2) {
            rvc.addElement(rightT.getModel().getValueAt(i2, indexR));
        }
        int rcolc = rightT.getModel().getColumnCount();
        int lcolc = leftT.getModel().getColumnCount();
        for (i = 0; i < rcolc; ++i) {
            if (i == indexR) continue;
            leftT.addColumn(rightT.getModel().getColumnName(i));
        }
        switch (joinType) {
            case 0: {
                for (i = 0; i < lrow_c; ++i) {
                    int i_find = rvc.indexOf(lvc.get(i));
                    if (i_find == -1) continue;
                    int curC = lcolc;
                    for (int j = 0; j < rcolc; ++j) {
                        if (j == indexR) continue;
                        leftT.getModel().setValueAt(rightT.getModel().getValueAt(i_find, j), i, curC++);
                    }
                }
                return leftT;
            }
            case 1: {
                Vector<Integer> markdel = new Vector<Integer>();
                for (int i3 = 0; i3 < lrow_c; ++i3) {
                    int i_find = rvc.indexOf(lvc.get(i3));
                    if (i_find != -1) {
                        int curC = lcolc;
                        for (int j = 0; j < rcolc; ++j) {
                            if (j == indexR) continue;
                            leftT.getModel().setValueAt(rightT.getModel().getValueAt(i_find, j), i3, curC++);
                        }
                        continue;
                    }
                    markdel.add(i3);
                }
                leftT.removeMarkedRows(markdel);
                return leftT;
            }
            case 2: {
                Vector<Integer> markdel_d = new Vector<Integer>();
                for (int i4 = 0; i4 < lrow_c; ++i4) {
                    int i_find = rvc.indexOf(lvc.get(i4));
                    if (i_find == -1) continue;
                    markdel_d.add(i4);
                }
                leftT.removeMarkedRows(markdel_d);
                return leftT;
            }
            case 3: {
                for (int i5 = 0; i5 < lrow_c; ++i5) {
                    int i_find = 0;
                    Vector<Integer> foundR = new Vector<Integer>();
                    boolean firstrec = false;
                    Object o_l = leftT.getModel().getValueAt(i5, indexL);
                    while ((i_find = rvc.indexOf(o_l, i_find)) != -1) {
                        foundR.add(i_find);
                        ++i_find;
                    }
                    Iterator iterator = foundR.iterator();
                    while (iterator.hasNext()) {
                        int fIndex = (Integer)iterator.next();
                        int curC = lcolc;
                        if (!firstrec) {
                            for (int j = 0; j < rcolc; ++j) {
                                if (j == indexR) continue;
                                leftT.getModel().setValueAt(rightT.getModel().getValueAt(fIndex, j), i5, curC++);
                            }
                            firstrec = true;
                            continue;
                        }
                        Object[] cartRow = leftT.getRow(i5);
                        leftT.getModel().insertRow(++i5, cartRow);
                        ++lrow_c;
                        for (int j = 0; j < rcolc; ++j) {
                            if (j == indexR) continue;
                            leftT.getModel().setValueAt(rightT.getModel().getValueAt(fIndex, j), i5, curC++);
                        }
                    }
                }
                return leftT;
            }
        }
        return leftT;
    }

    public static Hashtable<Object, Object> lookupInfo(ReportTableModel rightT, int indexR, int indexInfo) {
        Hashtable<Object, Object> lookup = new Hashtable<Object, Object>();
        int rrow_c = rightT.getModel().getRowCount();
        for (int i = 0; i < rrow_c; ++i) {
            Object key = rightT.getModel().getValueAt(i, indexR);
            Object value = rightT.getModel().getValueAt(i, indexInfo);
            if (key == null || value == null) continue;
            lookup.put(key, value);
        }
        return lookup;
    }

    public static Hashtable<Object, Object> lookupIndex(ReportTableModel rightT, int indexR) {
        Hashtable<Object, Object> lookup = new Hashtable<Object, Object>();
        int rrow_c = rightT.getModel().getRowCount();
        for (int i = 0; i < rrow_c; ++i) {
            Object key = rightT.getModel().getValueAt(i, indexR);
            if (key == null) continue;
            lookup.put(key, i);
        }
        return lookup;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector<Integer> matchCondition(ReportTableModel _rt, int colI, int cond, String condV) {
        if (_rt == null) {
            System.out.println("\n ERROR:Table not Set for Filtering");
            return null;
        }
        rowC = _rt.getModel().getRowCount();
        if (colI < 0) {
            return null;
        }
        if (cond < 2) {
            return null;
        }
        result_v = new Vector<Integer>();
        block8: for (i = 0; i < rowC; ++i) {
            switch (cond) {
                case 2: {
                    obj = _rt.getModel().getValueAt(i, colI);
                    if (obj != null) continue block8;
                    result_v.add(i);
                    continue block8;
                }
                case 3: {
                    obj = _rt.getModel().getValueAt(i, colI);
                    if (obj == null) continue block8;
                    result_v.add(i);
                    continue block8;
                }
                case 4: 
                case 5: {
                    found = false;
                    obj = _rt.getModel().getValueAt(i, colI);
                    if (obj == null || condV == null || "".equals(condV)) continue block8;
                    if (condV.startsWith("'") && condV.endsWith("'") && condV.length() - 1 > 0) {
                        condV = condV.substring(1, condV.length() - 1);
                    }
                    if (condV.startsWith("%") && condV.endsWith("%")) {
                        if (condV.length() == 1) {
                            found = true;
                        } else {
                            condV_s = condV.substring(1, condV.length() - 1);
                            found = obj.toString().contains(condV_s);
                        }
                    } else if (condV.startsWith("%")) {
                        condV_s = condV.substring(1, condV.length());
                        found = obj.toString().endsWith(condV_s);
                    } else if (condV.endsWith("%")) {
                        condV_s = condV.substring(0, condV.length() - 1);
                        found = obj.toString().startsWith(condV_s);
                    } else {
                        found = obj.toString().contains(condV);
                    }
                    if (cond == 4 && found) {
                        result_v.add(i);
                    }
                    if (cond != 5 || found) continue block8;
                    result_v.add(i);
                    continue block8;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    found = false;
                    obj = _rt.getModel().getValueAt(i, colI);
                    if (obj == null || condV == null || "".equals(condV)) continue block8;
                    if (condV.startsWith("'") && condV.endsWith("'") && condV.length() - 1 > 0) {
                        condV = condV.substring(1, condV.length() - 1);
                    }
                    if (obj instanceof Date) {
                        simpledateformat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
                        simpledateformat.setLenient(true);
                        date = simpledateformat.parse(condV, new ParsePosition(0));
                        if (date == null) {
                            System.out.println("\n ERROR:Could not Parse " + condV + " for Date object");
                            System.out.println("\n Date Format is dd/MM/yyyy hh:mm:ss");
                            return null;
                        }
                        if (cond == 6) {
                            found = date.compareTo((Date)obj) == 0;
                        } else if (cond == 7) {
                            found = date.compareTo((Date)obj) != 0;
                        } else if (cond == 8) {
                            found = date.compareTo((Date)obj) > 0;
                        } else if (cond == 9) {
                            found = date.compareTo((Date)obj) >= 0;
                        } else if (cond == 10) {
                            found = date.compareTo((Date)obj) < 0;
                        } else if (cond == 10) {
                            found = date.compareTo((Date)obj) <= 0;
                        }
                    } else if (obj instanceof Number) {
                        try {
                            num = Double.parseDouble(condV);
                            if (cond == 6) {
                                found = ((Double)obj).doubleValue() == num.doubleValue();
                            }
                            if (cond == 7) {
                                found = ((Double)obj).doubleValue() != num.doubleValue();
                            }
                            if (cond == 8) {
                                found = (Double)obj < num;
                            }
                            if (cond == 9) {
                                found = (Double)obj <= num;
                            }
                            if (cond == 10) {
                                found = (Double)obj > num;
                            }
                            if (cond != 10) ** GOTO lbl126
                            found = (Double)obj >= num;
                        }
                        catch (NumberFormatException nexp) {
                            System.out.println("\n ERROR:Could not Parse " + condV + " for Number object");
                            return null;
                        }
                    } else if (cond == 6) {
                        found = condV.compareTo(obj.toString()) == 0;
                    } else if (cond == 7) {
                        found = condV.compareTo(obj.toString()) != 0;
                    } else if (cond == 8) {
                        found = condV.compareTo(obj.toString()) > 0;
                    } else if (cond == 9) {
                        found = condV.compareTo(obj.toString()) >= 0;
                    } else if (cond == 10) {
                        found = condV.compareTo(obj.toString()) < 0;
                    } else if (cond == 10) {
                        v0 = found = condV.compareTo(obj.toString()) <= 0;
                    }
lbl126:
                    // 21 sources

                    if (!found) continue block8;
                    result_v.add(i);
                    continue block8;
                }
            }
        }
        return result_v;
    }

    public static PdfPTable createPDFTable(ReportTableModel rtm) {
        if (rtm == null) {
            return null;
        }
        int colC = rtm.getModel().getColumnCount();
        PdfPTable pdfTable = new PdfPTable(colC);
        for (int i = 0; i < colC; ++i) {
            PdfPCell c1 = new PdfPCell(new Phrase(rtm.getModel().getColumnName(i), DataDictionaryPDF.getFont(10, 1)));
            c1.setBackgroundColor(BaseColor.GRAY);
            c1.setHorizontalAlignment(1);
            pdfTable.addCell(c1);
        }
        pdfTable.setHeaderRows(1);
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            for (int j = 0; j < colC; ++j) {
                PdfPCell c1 = new PdfPCell();
                String valS = "";
                if (rtm.getModel().getValueAt(i, j) != null) {
                    valS = rtm.getModel().getValueAt(i, j).toString();
                }
                if (i % 2 == 0) {
                    c1.setBackgroundColor(new BaseColor(150, 255, 150, 255));
                }
                c1.setPhrase(new Phrase(valS, DataDictionaryPDF.getFont(9, 0)));
                pdfTable.addCell(c1);
            }
        }
        return pdfTable;
    }

    public static ReportTableModel sortRTM(ReportTableModel _rtm, final boolean asc) {
        int rowC = _rtm.getModel().getRowCount();
        final class Row
        implements Comparable<Row> {
            Object[] _row;

            public Row(Object[] row) {
                this._row = row;
            }

            private Object[] getRow() {
                return this._row;
            }

            @Override
            public int compareTo(Row r1) {
                Object[] row1 = this.getRow();
                Object[] row2 = r1.getRow();
                int comparison = 0;
                for (int i = 0; i < row1.length; ++i) {
                    String s2;
                    int cmp;
                    Object o1 = row1[i];
                    Object o2 = row2[i];
                    if (o1 == null && o2 == null) continue;
                    if (o1 == null) {
                        comparison = -1;
                        break;
                    }
                    if (o2 == null) {
                        comparison = 1;
                        break;
                    }
                    if (o2 instanceof Number) {
                        if (((Number)o2).doubleValue() > ((Number)o1).doubleValue()) {
                            comparison = -1;
                            break;
                        }
                        if (!(((Number)o2).doubleValue() < ((Number)o1).doubleValue())) continue;
                        comparison = 1;
                        break;
                    }
                    if (o2 instanceof Date) {
                        Calendar c1 = Calendar.getInstance();
                        Calendar c2 = Calendar.getInstance();
                        c1.setTime((Date)o1);
                        c2.setTime((Date)o2);
                        cmp = c1.compareTo(c2);
                        if (cmp == 0) continue;
                        comparison = cmp;
                        break;
                    }
                    String s1 = o1.toString();
                    cmp = s1.compareTo(s2 = o2.toString());
                    if (cmp == 0) continue;
                    comparison = cmp;
                    break;
                }
                if (comparison != 0) {
                    return !asc ? -comparison : comparison;
                }
                return comparison;
            }
        }
        Object[] rows = new Row[rowC];
        for (int i = 0; i < rowC; ++i) {
            Object[] row = _rtm.getRow(i);
            rows[i] = new Row(row);
        }
        Arrays.sort(rows);
        Object[] colName = _rtm.getAllColName();
        ReportTableModel newRTM = new ReportTableModel(colName, _rtm.isRTEditable(), true);
        for (int i = 0; i < rows.length; ++i) {
            newRTM.addFillRow(((Row)rows[i]).getRow());
        }
        return newRTM;
    }

    public static TimeSeries addRTMDataSet(TimeSeries dataset, ReportTableModel rtm, String datecol1, String numcol2, int timed) throws Exception {
        int rowC = rtm.getModel().getRowCount();
        int index = rtm.getColumnIndex(datecol1);
        int comIndex = rtm.getColumnIndex(numcol2);
        for (int i = 0; i < rowC; ++i) {
            try {
                Object ncell;
                Object dcell = rtm.getModel().getValueAt(i, index);
                if (dcell == null || (ncell = rtm.getModel().getValueAt(i, comIndex)) == null) continue;
                switch (timed) {
                    case 0: {
                        dataset.addOrUpdate((RegularTimePeriod)new Year((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 1: {
                        dataset.addOrUpdate((RegularTimePeriod)new Quarter((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 2: {
                        dataset.addOrUpdate((RegularTimePeriod)new Month((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 3: {
                        dataset.addOrUpdate((RegularTimePeriod)new Week((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 4: {
                        dataset.addOrUpdate((RegularTimePeriod)new Day((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 5: {
                        dataset.addOrUpdate((RegularTimePeriod)new Hour((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 6: {
                        dataset.addOrUpdate((RegularTimePeriod)new Minute((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 7: {
                        dataset.addOrUpdate((RegularTimePeriod)new Second((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                    case 8: {
                        dataset.addOrUpdate((RegularTimePeriod)new Millisecond((Date)dcell), (Number)((Double)ncell));
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                throw new Exception("\n Exception for row :" + i, e);
            }
        }
        return dataset;
    }

    public static XYSeries addRTMDataSet(XYSeries dataset, ReportTableModel rtm, String xcol1, String ycol2) throws Exception {
        int rowC = rtm.getModel().getRowCount();
        int index = rtm.getColumnIndex(xcol1);
        int comIndex = rtm.getColumnIndex(ycol2);
        for (int i = 0; i < rowC; ++i) {
            try {
                Object xcell = rtm.getModel().getValueAt(i, index);
                Object ycell = rtm.getModel().getValueAt(i, comIndex);
                if (xcell == null || ycell == null) continue;
                dataset.add((Number)new Double(xcell.toString()), (Number)new Double(ycell.toString()));
                continue;
            }
            catch (Exception e) {
                throw new Exception("\n Exception for row :" + i, e);
            }
        }
        return dataset;
    }

    public static ReportTableModel addEnrichment(ReportTableModel rtm, String xcol1, String ycol2, double[] val, int rtype) throws Exception {
        int rowC = rtm.getModel().getRowCount();
        int index = rtm.getColumnIndex(xcol1);
        int comIndex = rtm.getColumnIndex(ycol2);
        for (int i = 0; i < rowC; ++i) {
            try {
                Object ycell = rtm.getModel().getValueAt(i, comIndex);
                if (ycell != null && !ycell.toString().equals("")) continue;
                Object xcell = rtm.getModel().getValueAt(i, index);
                if (xcell == null) {
                    System.out.println("Can not create regression data. Domain data is also null");
                }
                if (rtype == 0) {
                    ycell = new Double(val[0] + val[1] * (Double)xcell);
                }
                if (rtype == 1) {
                    ycell = new Double(val[0] + val[1] * (Double)xcell + val[2] * (Double)xcell * (Double)xcell + val[3] * (Double)xcell * (Double)xcell * (Double)xcell + val[4] * (Double)xcell * (Double)xcell * (Double)xcell * (Double)xcell);
                }
                if (rtype == 2) {
                    ycell = new Double(val[0] * Math.pow((Double)xcell, val[1]));
                }
                rtm.setValueAt(ycell, i, comIndex);
                continue;
            }
            catch (Exception e) {
                throw new Exception("\n Exception for row :" + i, e);
            }
        }
        return rtm;
    }

    public static Hashtable<String, Vector<Integer>> getLuceneQueryForNull(ReportTableModel rtm, int nullCindex, String[] otherCols) {
        int otherClen = otherCols.length;
        int[] otherCindex = new int[otherClen];
        Hashtable<String, Vector<Integer>> queryHash = new Hashtable<String, Vector<Integer>>();
        for (int i = 0; i < otherClen; ++i) {
            otherCindex[i] = rtm.getColumnIndex(otherCols[i]);
        }
        int rowC = rtm.getModel().getRowCount();
        for (int i = 0; i < rowC; ++i) {
            Object o = rtm.getModel().getValueAt(i, nullCindex);
            if (o != null && !o.toString().equals("")) continue;
            Object[] otherO = new Object[otherClen];
            String luceneQ = "";
            for (int j = 0; j < otherClen; ++j) {
                otherO[j] = rtm.getModel().getValueAt(i, otherCindex[j]);
                if (otherO[j] == null) continue;
                if (!"".equals(luceneQ)) {
                    luceneQ = luceneQ + " AND ";
                }
                luceneQ = luceneQ + otherCols[j] + ":\"" + otherO[j].toString() + "\"";
            }
            Vector<Integer> val = queryHash.get(luceneQ);
            if (val == null) {
                val = new Vector();
            }
            if (!val.add(i)) continue;
            queryHash.put(luceneQ, val);
        }
        return queryHash;
    }

    public static Vector<Integer> replaceNullbyAttr(ReportTableModel rtm, int nullI, Hashtable<String, Vector<Integer>> hashT) {
        Vector<Integer> changedI = new Vector<Integer>();
        SimilarityCheckLucene simcheck = new SimilarityCheckLucene(rtm);
        simcheck.makeIndex();
        if (!simcheck.openIndex()) {
            return changedI;
        }
        Enumeration<String> e = hashT.keys();
        block2: while (e.hasMoreElements()) {
            String lucquey = e.nextElement();
            if (lucquey == null || "".equals(lucquey)) continue;
            Vector<Integer> listI = hashT.get(lucquey);
            Query qry = simcheck.parseQuery(lucquey);
            SimilarityCheckLucene.Hits hit = simcheck.searchIndex(qry);
            if (hit == null || hit.length() <= listI.size()) continue;
            for (int j = 0; j < hit.length(); ++j) {
                try {
                    Object[] row;
                    Object val;
                    Document doc = hit.doc(j);
                    String rowid = doc.get("at__rowid__");
                    int hitI = Integer.parseInt(rowid);
                    if (listI.contains(hitI) || (val = (row = rtm.getRow(hitI))[nullI]) == null) continue;
                    for (int i = 0; i < listI.size(); ++i) {
                        rtm.getModel().setValueAt(val, listI.get(i), nullI);
                        changedI.add(listI.get(i));
                    }
                    continue block2;
                }
                catch (Exception e1) {
                    System.out.println("Document match exception:" + e1.getLocalizedMessage());
                }
            }
        }
        simcheck.closeSeachIndex();
        return changedI;
    }

    public static ReportTableModel sampleRTM(ReportTableModel rtm, int count) {
        if (count < 0 || rtm == null || rtm.getModel().getRowCount() <= 0 || rtm.getModel().getColumnCount() <= 0) {
            return rtm;
        }
        String[] colName = rtm.getAllColNameStr();
        ReportTableModel newRTM = new ReportTableModel(colName, true, true);
        for (int i = 0; i < count; ++i) {
            int randInt = new Random().nextInt(count);
            Object[] row = rtm.getRow(randInt);
            newRTM.addFillRow(row);
        }
        return newRTM;
    }

    public static ReportTableModel[] splitRTM(ReportTableModel rtm, int count) {
        ReportTableModel[] newrtm = null;
        int rowc = rtm.getModel().getRowCount();
        if (count < 0 || rtm == null || rowc <= 0 || rtm.getModel().getColumnCount() <= 0) {
            newrtm = new ReportTableModel[]{rtm};
            return newrtm;
        }
        int grp1 = Math.floorDiv(rowc, count);
        newrtm = new ReportTableModel[count];
        String[] colName = rtm.getAllColNameStr();
        for (int i = 0; i < count; ++i) {
            ReportTableModel newRTM;
            newrtm[i] = newRTM = new ReportTableModel(colName, true, true);
            for (int j = i * grp1; j < i * grp1 + grp1; ++j) {
                newrtm[i].addFillRow(rtm.getRow(j));
            }
        }
        for (int j = count * grp1; j < rowc; ++j) {
            newrtm[count - 1].addFillRow(rtm.getRow(j));
        }
        return newrtm;
    }
}

