/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.ndtable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.arrah.framework.rdbms.SqlType;

public class ReportTableModel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Vector<Object> row_v = new Vector();
    private Vector<Object> column_v = new Vector();
    private int col_size = 0;
    private DefaultTableModel tabModel;
    private boolean _isEditable = false;
    private boolean showClass = false;
    private int[] classType = null;

    public ReportTableModel(String[] col) {
        this.addColumns(col);
        this.createTable(false);
    }

    public ReportTableModel(Object[] col) {
        this.addColumns(col);
        this.createTable(false);
    }

    public ReportTableModel(Object[] col, boolean isEditable) {
        this.addColumns(col);
        this.createTable(isEditable);
    }

    public ReportTableModel(String[] col, boolean isEditable) {
        this.addColumns(col);
        this.createTable(isEditable);
    }

    public ReportTableModel(String[] col, boolean isEditable, boolean colClass) {
        this.addColumns(col);
        this.createTable(isEditable);
        this.showClass = colClass;
    }

    public ReportTableModel(String[] col, int[] sqlType, boolean isEditable, boolean colClass) {
        this.addColumns(col);
        this.createTable(isEditable);
        this.showClass = colClass;
        this.classType = sqlType;
    }

    public ReportTableModel(Object[] col, boolean isEditable, boolean colClass) {
        this.addColumns(col);
        this.createTable(isEditable);
        this.showClass = colClass;
    }

    public ReportTableModel(String less, String more, String b_less1, String b_more1, String b_less2, String b_more2) {
        String[] columnNames = new String[]{"<html><b><i>Values</i></b></html>", "<html><b>Aggregate</i></b></html>", "<html><b> &lt;  <i>" + less + "</i></b></html>", "<html><b> &gt;  <i>" + more + "</i></b></html>", "<html><b><i>" + b_less1 + "</i>&lt;&gt;<i>" + b_more1 + "</i></b></html>", "<html><b><i>" + b_less2 + "</i>&lt;&gt;<i>" + b_more2 + "</i></b></html>"};
        String[][] data = new String[][]{{"<html><b>COUNT</b></html>", "", "", "", "", ""}, {"<html><b>AVG</b></html>", "", "", "", "", ""}, {"<html><b>MAX</b></html>", "", "", "", "", ""}, {"<html><b>MIN</b></html>", "", "", "", "", ""}, {"<html><b>SUM</b></html>", "", "", "", "", ""}, {"<html><b>DUPLICATE</b></html>", "", "", "", "", ""}};
        this.addColumns(columnNames);
        this.addRows(data);
        this.createTable(false);
    }

    private void createTable(final boolean isEditable) {
        this._isEditable = isEditable;
        this.tabModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                String colN = this.getColumnName(col);
                int[] colIndex = new int[]{col};
                if (isEditable) {
                    return true;
                }
                return colN.endsWith("Editable");
            }

            @Override
            public Class<?> getColumnClass(int col) {
                if (ReportTableModel.this.showClass) {
                    if (ReportTableModel.this.classType != null) {
                        return SqlType.getClass(ReportTableModel.this.classType[col]);
                    }
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        if (this.getValueAt(i, col) == null) continue;
                        return this.getValueAt(i, col).getClass();
                    }
                    return new Object().getClass();
                }
                return new Object().getClass();
            }
        };
        this.tabModel.setDataVector(this.row_v, this.column_v);
    }

    public void setValueAt(String s, int row, int col) {
        if (row < 0 || col < 0) {
            return;
        }
        this.tabModel.setValueAt(s, row, col);
    }

    public void setValueAt(Object s, int row, int col) {
        if (row < 0 || col < 0) {
            return;
        }
        this.tabModel.setValueAt(s, row, col);
    }

    private void addColumns(String[] colName) {
        int i;
        for (i = 0; i < colName.length; ++i) {
            this.column_v.addElement(colName[i]);
        }
        this.col_size = i;
    }

    private void addColumns(Object[] colName) {
        int i;
        for (i = 0; i < colName.length; ++i) {
            this.column_v.addElement(colName[i].toString());
        }
        this.col_size = i;
    }

    private void addRows(String[][] rowData) {
        for (int i = 0; i < rowData.length; ++i) {
            Vector<String> newRow = new Vector<String>();
            for (int j = 0; j < rowData[i].length; ++j) {
                newRow.addElement(rowData[i][j]);
            }
            this.row_v.addElement(newRow);
        }
    }

    public void addFillRow(String[] rowset) {
        Vector<String> newRow = new Vector<String>();
        for (int j = 0; j < rowset.length; ++j) {
            newRow.addElement(rowset[j]);
        }
        this.row_v.addElement(newRow);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addFillRow(Object[] rowset) {
        Vector<Object> newRow = new Vector<Object>();
        for (int j = 0; j < rowset.length; ++j) {
            newRow.addElement(rowset[j]);
        }
        this.row_v.addElement(newRow);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addFillRow(Object[] rowset, Object[] rowset1) {
        int j;
        Vector<Object> newRow = new Vector<Object>();
        for (j = 0; j < rowset.length; ++j) {
            newRow.addElement(rowset[j]);
        }
        for (j = 0; j < rowset1.length; ++j) {
            newRow.addElement(rowset1[j]);
        }
        this.row_v.addElement(newRow);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addFillRow(Vector<?> rowset) {
        this.row_v.addElement(rowset);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addRow() {
        Vector<String> newRow = new Vector<String>();
        for (int j = 0; j < this.col_size; ++j) {
            newRow.addElement("");
        }
        this.row_v.addElement(newRow);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addNullRow() {
        Vector<Object> newRow = new Vector<Object>();
        for (int j = 0; j < this.col_size; ++j) {
            newRow.addElement(null);
        }
        this.row_v.addElement(newRow);
        this.tabModel.fireTableRowsInserted(this.tabModel.getRowCount(), 1);
    }

    public void addColumn(String name) {
        this.tabModel.addColumn(name);
        this.tabModel.fireTableStructureChanged();
        this.col_size = this.tabModel.getColumnCount();
    }

    public void addRows(int startRow, int noOfRows) {
        int col_c = this.tabModel.getColumnCount();
        Object[] row = new Object[col_c];
        for (int i = 0; i < noOfRows; ++i) {
            this.tabModel.insertRow(startRow, row);
        }
        this.tabModel.fireTableRowsInserted(startRow, noOfRows);
    }

    public void removeRows(int startRow, int noOfRows) {
        for (int i = 0; i < noOfRows; ++i) {
            this.tabModel.removeRow(startRow);
        }
        this.tabModel.fireTableRowsDeleted(startRow, noOfRows);
    }

    public void removeMarkedRows(Vector<Integer> marked) {
        Object[] a = new Integer[marked.size()];
        a = marked.toArray(a);
        Arrays.sort(a);
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            this.tabModel.removeRow((Integer)a[len - 1 - i]);
            this.tabModel.fireTableRowsDeleted((Integer)a[len - 1 - i], 1);
        }
    }

    public Object[] copyRow(int startRow) {
        int col_c = this.tabModel.getColumnCount();
        Object[] row = new Object[col_c];
        for (int i = 0; i < col_c; ++i) {
            row[i] = this.tabModel.getValueAt(startRow, i);
        }
        return row;
    }

    public void pasteRow(int startRow, Vector<Object[]> row) {
        int row_c = this.tabModel.getRowCount();
        int col_c = this.tabModel.getColumnCount();
        int vci = 0;
        int saveR = row_c - (startRow + row.size());
        if (saveR < 0) {
            System.out.println("Not Enough Rows left to paste " + row.size() + " Rows \n Use 'Insert Clip' instead");
            return;
        }
        for (int i = row.size() - 1; i >= 0; --i) {
            Object[] a;
            col_c = col_c > (a = row.elementAt(vci++)).length ? a.length : col_c;
            for (int j = 0; j < col_c; ++j) {
                this.tabModel.setValueAt(a[j], startRow + i, j);
            }
        }
    }

    public void pasteRow(int startRow, Object[] row) {
        int row_c = this.tabModel.getRowCount();
        int col_c = this.tabModel.getColumnCount();
        int saveR = row_c - (startRow + 1);
        if (saveR < 0) {
            System.out.println("Not Enough Rows left to paste 1 Row \n Use 'Insert Clip' instead");
            return;
        }
        Object[] a = row;
        col_c = col_c > a.length ? a.length : col_c;
        for (int j = 0; j < col_c; ++j) {
            this.tabModel.setValueAt(a[j], startRow, j);
        }
    }

    public DefaultTableModel getModel() {
        return this.tabModel;
    }

    public boolean isRTEditable() {
        return this._isEditable;
    }

    public boolean isRTShowClass() {
        return this.showClass;
    }

    public static ReportTableModel copyTable(ReportTableModel rpt, boolean editable, boolean showClass) {
        if (rpt == null) {
            return null;
        }
        int colC = rpt.tabModel.getColumnCount();
        int rowC = rpt.tabModel.getRowCount();
        String[] colName = new String[colC];
        for (int i = 0; i < colC; ++i) {
            colName[i] = rpt.tabModel.getColumnName(i);
        }
        ReportTableModel newRT = new ReportTableModel(colName, editable, showClass);
        for (int i = 0; i < rowC; ++i) {
            newRT.addRow();
            for (int j = 0; j < colC; ++j) {
                newRT.tabModel.setValueAt(rpt.tabModel.getValueAt(i, j), i, j);
            }
        }
        return newRT;
    }

    public Object[] getRow(int rowIndex) {
        int colC = this.tabModel.getColumnCount();
        Object[] obj = new Object[colC];
        if (rowIndex < 0 || rowIndex >= this.tabModel.getRowCount()) {
            return obj;
        }
        for (int i = 0; i < colC; ++i) {
            obj[i] = this.tabModel.getValueAt(rowIndex, i);
        }
        return obj;
    }

    public Object[] getSelectedColRow(int rowIndex, int[] colI) {
        int colC = colI.length;
        Object[] obj = new Object[colC];
        if (rowIndex < 0 || rowIndex >= this.tabModel.getRowCount()) {
            return obj;
        }
        for (int i = 0; i < colC; ++i) {
            try {
                obj[i] = this.tabModel.getValueAt(rowIndex, colI[i]);
                continue;
            }
            catch (Exception e) {
                obj[i] = null;
            }
        }
        return obj;
    }

    public void cleanallRow() {
        int i = this.tabModel.getRowCount();
        this.removeRows(0, i);
    }

    public boolean isEmptyRow(int rowid) {
        Object[] rowObj = this.getRow(rowid);
        for (int i = 0; i < rowObj.length; ++i) {
            if (rowObj[i] == null || "".equals(rowObj[i].toString())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmptyExceptCols(int rowid, int[] colIndex) {
        boolean isColMatch = false;
        Object[] rowObj = this.getRow(rowid);
        for (int i = 0; i < rowObj.length; ++i) {
            isColMatch = false;
            for (int j = 0; j < colIndex.length; ++j) {
                if (i != colIndex[j]) continue;
                isColMatch = true;
            }
            if (isColMatch || rowObj[i] == null || "".equals(rowObj[i].toString())) continue;
            return false;
        }
        return true;
    }

    public static int getColumnIndex(ReportTableModel rpt, String colName) {
        int row_c = rpt.getModel().getColumnCount();
        for (int i = 0; i < row_c; ++i) {
            if (!colName.equals(rpt.getModel().getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public int getColumnIndex(String colName) {
        int row_c = this.getModel().getColumnCount();
        for (int i = 0; i < row_c; ++i) {
            if (!colName.equals(this.getModel().getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public Object[] getAllColName() {
        int colC = this.getModel().getColumnCount();
        Object[] colN = new Object[colC];
        for (int i = 0; i < colC; ++i) {
            colN[i] = this.getModel().getColumnName(i);
        }
        return colN;
    }

    public String[] getAllColNameStr() {
        int colC = this.getModel().getColumnCount();
        String[] colN = new String[colC];
        for (int i = 0; i < colC; ++i) {
            colN[i] = this.getModel().getColumnName(i);
        }
        return colN;
    }

    public Object[] getColData(int index) {
        int row_c = this.getModel().getRowCount();
        Object[] colN = new Object[row_c];
        for (int i = 0; i < row_c; ++i) {
            colN[i] = this.getModel().getValueAt(i, index);
        }
        return colN;
    }

    public Object[] getColDataRandom(int index, int count) {
        Object[] colN = new Object[count];
        Vector<Object> vc = new Vector<Object>();
        int row_c = this.getModel().getRowCount();
        for (int rowcount = 0; rowcount < count; ++rowcount) {
            int newc = new Random().nextInt(row_c);
            Object o = this.getModel().getValueAt(newc, index);
            vc.add(o);
        }
        return vc.toArray(colN);
    }

    public Object[] getColDataRandom(String colName, int count) {
        int index = this.getColumnIndex(colName);
        if (index < 0) {
            return null;
        }
        return this.getColDataRandom(index, count);
    }

    public Vector<Object> getColDataV(int index) {
        int row_c = this.getModel().getRowCount();
        Vector<Object> vc = new Vector<Object>();
        for (int i = 0; i < row_c; ++i) {
            vc.add(this.getModel().getValueAt(i, index));
        }
        return vc;
    }

    public Vector<Double> getColDataVD(int index) {
        int row_c = this.getModel().getRowCount();
        Vector<Double> vc = new Vector<Double>();
        for (int i = 0; i < row_c; ++i) {
            Object colv = this.getModel().getValueAt(i, index);
            if (colv == null || "".equals(colv.toString())) continue;
            if (colv instanceof Number) {
                vc.add((double)((Double)colv));
                continue;
            }
            if (!(colv instanceof String)) continue;
            try {
                double newv = Double.parseDouble(colv.toString());
                vc.add(newv);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vc;
    }

    public Object[] getColData(String colName) {
        int colI = this.getColumnIndex(colName);
        if (colI < 0) {
            return null;
        }
        return this.getColData(colI);
    }

    public int[] getClassType() {
        return this.classType;
    }
}

