/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;

public class AllTableProfile {
    private ReportTableModel __rt = new ReportTableModel(new String[]{"Table", "Column", "Record", "Unique", "Pattern", "Null", "Zero", "Empty"});

    public AllTableProfile() {
        try {
            this.createRows();
        }
        catch (SQLException e) {
            System.out.println("\n SQL exception in Data Info");
            System.out.println(e.getMessage());
        }
    }

    private void createRows() throws SQLException {
        Vector<String> vc = new Vector<String>();
        Rdbms_conn.openConn();
        DatabaseMetaData dbmd = Rdbms_conn.getMetaData();
        String s_pattern = Rdbms_conn.getHValue("Database_SchemaPattern");
        String t_pattern = Rdbms_conn.getHValue("Database_TablePattern");
        String t_type = Rdbms_conn.getHValue("Database_TableType");
        String n_catalog = Rdbms_conn.getHValue("Database_Catalog");
        n_catalog = "";
        String d_dsn = Rdbms_conn.getHValue("Database_DSN");
        ResultSet rs = dbmd.getTables(n_catalog.compareTo("") == 0 ? (n_catalog = null) : n_catalog, s_pattern.compareTo("") == 0 ? (s_pattern = null) : s_pattern, t_pattern.compareTo("") == 0 ? (t_pattern = null) : t_pattern, t_type.split(","));
        String tbl = "";
        while (rs.next()) {
            tbl = rs.getString(3);
            vc.add(tbl);
        }
        rs.close();
        String dbType = Rdbms_conn.getDBType();
        Enumeration e = vc.elements();
        while (e.hasMoreElements()) {
            tbl = (String)e.nextElement();
            Vector<String> vc_c = new Vector<String>();
            ResultSet rs_col = dbmd.getColumns(n_catalog, s_pattern, tbl, null);
            while (rs_col.next()) {
                String tmp = rs_col.getString(4);
                vc_c.add(tmp);
            }
            rs_col.close();
            Enumeration et = vc_c.elements();
            while (et.hasMoreElements()) {
                String all_v = "0";
                String dist_v = "0";
                String null_v = "0";
                String zero_v = "0";
                String empty_v = "0";
                String pattern_v = "0";
                String col = (String)et.nextElement();
                QueryBuilder c_prof = new QueryBuilder(d_dsn, tbl, col, dbType);
                String all_c = c_prof.count_query_w(false, "row_count");
                String dist_c = c_prof.count_query_w(true, "row_count");
                String null_c = c_prof.get_nullCount_query_w("Null");
                String zero_c = c_prof.get_zeroCount_query_w("0");
                String empty_c = c_prof.get_zeroCount_query_w("''");
                String pattern_c = c_prof.get_pattern_query();
                try {
                    rs_col = Rdbms_conn.runQuery(all_c);
                    while (rs_col.next()) {
                        all_v = rs_col.getString("row_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    all_v = "N/A";
                }
                try {
                    rs_col = Rdbms_conn.runQuery(dist_c);
                    while (rs_col.next()) {
                        dist_v = rs_col.getString("row_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    dist_v = "N/A";
                }
                try {
                    rs_col = Rdbms_conn.runQuery(null_c);
                    while (rs_col.next()) {
                        null_v = rs_col.getString("equal_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    null_v = "N/A";
                }
                try {
                    rs_col = Rdbms_conn.runQuery(zero_c);
                    while (rs_col.next()) {
                        zero_v = rs_col.getString("equal_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    zero_v = "N/A";
                }
                try {
                    rs_col = Rdbms_conn.runQuery(empty_c);
                    while (rs_col.next()) {
                        empty_v = rs_col.getString("equal_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    empty_v = "N/A";
                }
                try {
                    rs_col = Rdbms_conn.runQuery(pattern_c);
                    while (rs_col.next()) {
                        pattern_v = rs_col.getString("row_count");
                    }
                    rs_col.close();
                }
                catch (SQLException s_exp) {
                    pattern_v = "N/A";
                }
                String[] row = new String[]{tbl, col, all_v, dist_v, pattern_v, null_v, zero_v, empty_v};
                this.__rt.addFillRow(row);
            }
        }
        Rdbms_conn.closeConn();
    }

    public ReportTableModel getTable() {
        return this.__rt;
    }
}

