/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.rdbms;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.arrah.framework.ndtable.RTMUtil;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.profile.DBMetaInfo;
import org.arrah.framework.profile.TableMetaInfo;
import org.arrah.framework.rdbms.Rdbms_conn;

public class DataDictionaryPDF {
    private Vector<String> _tableN = Rdbms_conn.getTable();

    public PdfPTable getTableMetaData(int tabIndex) {
        ReportTableModel reporttable = null;
        reporttable = TableMetaInfo.populateTable(2, tabIndex, tabIndex + 1, reporttable);
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public PdfPTable getTableData(int tabIndex) {
        ReportTableModel reporttable = null;
        reporttable = TableMetaInfo.populateTable(4, tabIndex, tabIndex + 1, reporttable);
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public PdfPTable getTableIndex(int tabIndex) {
        ReportTableModel reporttable = null;
        reporttable = TableMetaInfo.populateTable(1, tabIndex, tabIndex + 1, reporttable);
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public PdfPTable getTableKey(String table) throws SQLException {
        ReportTableModel reporttable = null;
        reporttable = TableMetaInfo.tableKeyInfo(table);
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public PdfPTable getDBParameter() throws SQLException {
        ReportTableModel reporttable = null;
        DBMetaInfo dbmeta = new DBMetaInfo();
        reporttable = dbmeta.getParameterInfo();
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public PdfPTable getDBProcedure() throws SQLException {
        ReportTableModel reporttable = null;
        DBMetaInfo dbmeta = new DBMetaInfo();
        reporttable = dbmeta.getProcedureInfo();
        PdfPTable pdfTable = RTMUtil.createPDFTable(reporttable);
        return pdfTable;
    }

    public static void createPDFfromRTM(File pdfFile, ReportTableModel rtm) throws FileNotFoundException, DocumentException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFile));
        document.open();
        PdfPTable pdftable = RTMUtil.createPDFTable(rtm);
        document.add((Element)pdftable);
        document.close();
    }

    public void createDDPDF(OutputStream output) throws FileNotFoundException, DocumentException, SQLException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)output);
        document.open();
        this.addTitlePage(document);
        this.createPDFBody(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFBody(Document document) throws DocumentException, SQLException {
        try {
            for (int i = 0; i < this._tableN.size(); ++i) {
                Paragraph comment = new Paragraph(i + 1 + "." + this._tableN.get(i));
                comment.setAlignment(0);
                document.add((Element)comment);
                this.addEmptyLine(document, 1);
                comment = new Paragraph("Metadata Information");
                comment.setAlignment(0);
                document.add((Element)comment);
                this.addEmptyLine(document, 1);
                PdfPTable pdfTable = this.getTableMetaData(i);
                if (pdfTable == null) continue;
                pdfTable.setWidthPercentage(100.0f);
                document.add((Element)pdfTable);
                this.addEmptyLine(document, 1);
                comment = new Paragraph("Data Information");
                comment.setAlignment(0);
                document.add((Element)comment);
                this.addEmptyLine(document, 1);
                pdfTable = this.getTableData(i);
                if (pdfTable == null) continue;
                pdfTable.setWidthPercentage(100.0f);
                document.add((Element)pdfTable);
                this.addEmptyLine(document, 1);
                try {
                    comment = new Paragraph("PK-FK Information");
                    comment.setAlignment(0);
                    document.add((Element)comment);
                    this.addEmptyLine(document, 1);
                    pdfTable = this.getTableKey(this._tableN.get(i));
                    pdfTable.setWidthPercentage(100.0f);
                    document.add((Element)pdfTable);
                    this.addEmptyLine(document, 1);
                }
                catch (SQLException sqlex) {
                    System.out.println("\n Method getTableKey Not Supported.");
                }
                comment = new Paragraph("Index Information");
                comment.setAlignment(0);
                document.add((Element)comment);
                this.addEmptyLine(document, 1);
                pdfTable = this.getTableIndex(i);
                if (pdfTable == null) continue;
                pdfTable.setWidthPercentage(100.0f);
                document.add((Element)pdfTable);
                this.addEmptyLine(document, 1);
            }
            Paragraph proc = new Paragraph("Procedure Information");
            proc.setAlignment(0);
            document.add((Element)proc);
            this.addEmptyLine(document, 2);
            PdfPTable pdfTable = null;
            try {
                pdfTable = this.getDBProcedure();
                if (pdfTable != null) {
                    pdfTable.setWidthPercentage(100.0f);
                    document.add((Element)pdfTable);
                    this.addEmptyLine(document, 2);
                }
            }
            catch (SQLException sqlexp) {
                System.out.println("\n Method getDBProcedure Not Supported.");
            }
            Paragraph param = new Paragraph("Parameter Information");
            param.setAlignment(0);
            document.add((Element)param);
            this.addEmptyLine(document, 2);
            try {
                pdfTable = this.getDBParameter();
                if (pdfTable != null) {
                    pdfTable.setWidthPercentage(100.0f);
                    document.add((Element)pdfTable);
                    this.addEmptyLine(document, 2);
                }
            }
            catch (SQLException sqlexp) {
                System.out.println("\n Method getDBParameter Not Supported.");
            }
            Paragraph eoDoc = new Paragraph("End of Document");
            eoDoc.setAlignment(1);
            document.add((Element)eoDoc);
            document.close();
            System.out.println("\n Data Dictionary File saved successfully");
        }
        catch (Exception e) {
            document.close();
            System.out.println("\n Data Dictionary File closed Abnormally");
            try {
                throw e;
            }
            catch (Exception exception) {
            }
        }
        finally {
            document.close();
        }
    }

    public void createDDPDF(File pdfFile) throws FileNotFoundException, DocumentException, SQLException {
        Document document = new Document();
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfFile));
        document.open();
        this.addTitlePage(document);
        this.createPDFBody(document);
    }

    private void addEmptyLine(Document doc, int number) throws DocumentException {
        for (int i = 0; i < number; ++i) {
            doc.add((Element)new Paragraph(" "));
        }
    }

    private void addTitlePage(Document document) throws DocumentException {
        this.addEmptyLine(document, 5);
        Paragraph title = new Paragraph("Data Dictionary by Arrah technology");
        title.setAlignment(1);
        document.add((Element)title);
        this.addEmptyLine(document, 1);
        Paragraph url = new Paragraph("http://sourceforge.net/projects/dataquality/");
        url.setAlignment(1);
        document.add((Element)url);
        this.addEmptyLine(document, 3);
        Paragraph rtime = new Paragraph("Report generated on: " + new Date());
        rtime.setAlignment(1);
        document.add((Element)rtime);
        document.newPage();
    }

    public static Font getFont(final int size, final int style) {
        Font f = new Font(){

            public float getSize() {
                return size;
            }

            public int getStyle() {
                return style;
            }
        };
        return f;
    }
}

