/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.scheduler;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.arrah.framework.scheduler.ScheduleJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduler {
    String quer;
    int hours;
    int minutes;
    int seconds;
    JobKey jk;
    Date d1 = new Date();
    int dayofWeek;
    int dayOfMonth;
    CronTrigger trigger1;
    SimpleTrigger trigger;
    Date date = new Date();
    private final String jcbSfrequency;
    private final String jcbFrequency;
    private final Date jdcEdate;
    private final int startdayofMonth;
    private final Hashtable<String, String> hashtable;
    private final String jcbRule;

    public QuartzScheduler(String text, int hour, int minute, int second, String jcbSfrequency, String jcbFrequency, Date jdcEdate, int startdayofMonth, Hashtable<String, String> hashtable, String jcbRule) throws SchedulerException, InterruptedException {
        this.hours = hour;
        this.minutes = minute;
        this.seconds = second;
        this.quer = text;
        this.jcbSfrequency = jcbSfrequency;
        this.jcbFrequency = jcbFrequency;
        this.jdcEdate = jdcEdate;
        this.startdayofMonth = startdayofMonth;
        this.hashtable = hashtable;
        this.jcbRule = jcbRule;
        try {
            this.task();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void task() throws SchedulerException, InterruptedException, ParseException {
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        String key = "ExecuteJob1";
        String value = "Report Generation1";
        JobKey jobKey = new JobKey(key, value);
        JobDataMap jobDataMap = new JobDataMap(this.hashtable);
        JobDetail job = JobBuilder.newJob(ScheduleJob.class).withIdentity(jobKey).usingJobData(jobDataMap).usingJobData("query", this.quer).usingJobData("jcbRule", this.jcbRule).build();
        if (this.jcbFrequency.equals("One Time")) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, this.hours);
            cal.set(12, this.minutes);
            cal.set(13, this.seconds);
            Date startTime = cal.getTime();
            this.trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger", value).startAt(startTime).build();
            sched.scheduleJob(job, (Trigger)this.trigger);
        }
        if (this.jcbFrequency.equals("Daily")) {
            this.trigger1 = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger1", "Report Generation3").withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)this.hours, (int)this.minutes)).build();
        } else if (this.jcbFrequency.equals("Weekly")) {
            this.dayoftheWeek();
            this.trigger1 = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger1", "Report Generation3").withSchedule((ScheduleBuilder)CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)this.dayofWeek, (int)this.hours, (int)this.minutes)).build();
        } else if (this.jcbFrequency.equals("Monthly")) {
            this.trigger1 = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger1", "Report Generation3").withSchedule((ScheduleBuilder)CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)this.startdayofMonth, (int)this.hours, (int)this.minutes)).endAt(this.jdcEdate).build();
        }
        if (this.trigger1 != null) {
            sched.scheduleJob(job, (Trigger)this.trigger1);
        }
        sched.start();
    }

    private int dayoftheWeek() {
        if (this.jcbSfrequency.equals("SUNDAY")) {
            this.dayofWeek = 1;
        }
        if (this.jcbSfrequency.equals("MONDAY")) {
            this.dayofWeek = 2;
        }
        if (this.jcbSfrequency.equals("TUESDAY")) {
            this.dayofWeek = 3;
        }
        if (this.jcbSfrequency.equals("WEDNESDAY")) {
            this.dayofWeek = 4;
        }
        if (this.jcbSfrequency.equals("THURSDAY")) {
            this.dayofWeek = 5;
        }
        if (this.jcbSfrequency.equals("FRIDAY")) {
            this.dayofWeek = 6;
        }
        if (this.jcbSfrequency.equals("SATURDAY")) {
            this.dayofWeek = 7;
        }
        return this.dayofWeek;
    }
}

