/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.util;

import java.util.Vector;

public class StringCaseFormatUtil {
    public static String toUpperCase(String s) {
        return s.toUpperCase();
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase();
    }

    public static String toTitleCase(String s) {
        s = s.toLowerCase();
        int strl = s.length();
        char[] holder = new char[strl];
        boolean titleActive = true;
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if (titleActive || i == 0) {
                nextC = Character.toTitleCase(nextC);
                titleActive = false;
            }
            if (Character.isWhitespace(nextC)) {
                titleActive = true;
            }
            holder[i] = nextC;
        }
        return new String(holder);
    }

    public static String toSentenceCase(String s, char endOfLineSym) {
        s = s.toLowerCase();
        int strl = s.length();
        char[] holder = new char[strl];
        boolean sentenceActive = true;
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if ((sentenceActive || i == 0) && Character.isLetterOrDigit(nextC)) {
                nextC = Character.toUpperCase(nextC);
                sentenceActive = false;
            }
            if (Character.getType(nextC) == 13 || Character.getType(nextC) == 14 || nextC == endOfLineSym) {
                sentenceActive = true;
            }
            holder[i] = nextC;
        }
        return new String(holder);
    }

    public static boolean isUpperCase(String s) {
        int strl = s.length();
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if (Character.isUpperCase(nextC)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(String s) {
        int strl = s.length();
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if (Character.isLowerCase(nextC)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTitleCase(String s) {
        int strl = s.length();
        boolean titleActive = true;
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if (!titleActive && (Character.isTitleCase(nextC) || Character.isUpperCase(nextC))) {
                return false;
            }
            if (titleActive || i == 0) {
                if (!Character.isTitleCase(nextC) && !Character.isUpperCase(nextC)) {
                    return false;
                }
                titleActive = false;
            }
            if (!Character.isWhitespace(nextC)) continue;
            titleActive = true;
        }
        return true;
    }

    public static boolean isSentenceCase(String s, char endOfLineSym) {
        int strl = s.length();
        boolean sentenceActive = true;
        for (int i = 0; i < strl; ++i) {
            char nextC = s.charAt(i);
            if (!sentenceActive && Character.isLetterOrDigit(nextC) && Character.isUpperCase(nextC)) {
                return false;
            }
            if ((sentenceActive || i == 0) && Character.isLetterOrDigit(nextC)) {
                if (!Character.isUpperCase(nextC)) {
                    return false;
                }
                sentenceActive = false;
            }
            if (Character.getType(nextC) != 13 && Character.getType(nextC) != 14 && nextC != endOfLineSym) continue;
            sentenceActive = true;
        }
        return true;
    }

    public static String[] splitColStringWidth(String value, int len) {
        String[] output = new String[]{"", ""};
        if (value == null || "".equals(value) || value.length() <= len) {
            return output;
        }
        output[0] = value.substring(0, len);
        output[1] = value.substring(len);
        return output;
    }

    public static String[] splitColString(String value, String regex) {
        String[] output = new String[]{"", ""};
        if (value == null || "".equals(value)) {
            return output;
        }
        output = value.split(regex, 2);
        return output;
    }

    public static String[] splitColSubString(String value, String regex) {
        String[] output = null;
        if (value == null || "".equals(value)) {
            return output;
        }
        output = value.split(regex);
        return output;
    }

    public static String removeMetaCharString(String oldString, String skipString) {
        String newString = "";
        for (int curIndex = 0; curIndex < oldString.length(); ++curIndex) {
            char c = oldString.charAt(curIndex);
            Character ch = new Character(c);
            if (!Character.isLetterOrDigit(c) && !skipString.contains(ch.toString())) continue;
            newString = newString + ch.toString();
        }
        return newString;
    }

    public static String removeMetaCharString(String oldString, String skipString, boolean start, boolean inBtw, boolean end) {
        String newString = "";
        int len = oldString.length();
        char c = oldString.charAt(0);
        Character ch = new Character(c);
        if (start) {
            if (Character.isLetterOrDigit(c) || skipString.contains(ch.toString())) {
                newString = newString + ch.toString();
            }
        } else {
            newString = newString + ch.toString();
        }
        if (len > 1) {
            for (int curIndex = 1; curIndex < len - 1; ++curIndex) {
                char c2 = oldString.charAt(curIndex);
                Character ch2 = new Character(c2);
                if (inBtw) {
                    if (!Character.isLetterOrDigit(c2) && !skipString.contains(ch2.toString())) continue;
                    newString = newString + ch2.toString();
                    continue;
                }
                newString = newString + ch2.toString();
            }
        }
        if (len > 1) {
            c = oldString.charAt(len - 1);
            ch = new Character(c);
            if (end) {
                if (Character.isLetterOrDigit(c) || skipString.contains(ch.toString())) {
                    newString = newString + ch.toString();
                }
            } else {
                newString = newString + ch.toString();
            }
        }
        return newString;
    }

    public static String removeCharacterString(String oldString, String skipString) {
        String newString = "";
        for (int curIndex = 0; curIndex < oldString.length(); ++curIndex) {
            char c = oldString.charAt(curIndex);
            Character ch = new Character(c);
            if (skipString.contains(ch.toString())) continue;
            newString = newString + ch.toString();
        }
        return newString;
    }

    public static String removeCharacterString(String oldString, String skipString, boolean start, boolean inBtw, boolean end) {
        String newString = "";
        int len = oldString.length();
        for (int curIndex = 0; curIndex < len; ++curIndex) {
            char c = oldString.charAt(curIndex);
            Character ch = new Character(c);
            if (curIndex == 0) {
                if (start) {
                    if (skipString.contains(ch.toString())) continue;
                    newString = newString + ch.toString();
                    continue;
                }
                newString = newString + ch.toString();
                continue;
            }
            if (curIndex < len - 1) {
                if (inBtw) {
                    if (skipString.contains(ch.toString())) continue;
                    newString = newString + ch.toString();
                    continue;
                }
                newString = newString + ch.toString();
                continue;
            }
            if (end) {
                if (skipString.contains(ch.toString())) continue;
                newString = newString + ch.toString();
                continue;
            }
            newString = newString + ch.toString();
        }
        return newString;
    }

    public static String replaceString(String fullString, String matchString, String replaceString, boolean fromStart) {
        String newString = "";
        newString = fromStart ? fullString.replaceFirst(matchString, replaceString) : fullString.replaceAll(matchString, replaceString);
        return newString;
    }

    public static int matchString(String first, String second, boolean fromStart) {
        int sc;
        int commonc;
        int matchc = 0;
        if (first == null || second == null) {
            return matchc;
        }
        int fc = first.length();
        int n = commonc = fc > (sc = second.length()) ? sc : fc;
        if (!fromStart) {
            first = new StringBuffer(first).reverse().toString();
            second = new StringBuffer(second).reverse().toString();
        }
        for (int i = 0; i < commonc && first.charAt(i) == second.charAt(i); ++i) {
            ++matchc;
        }
        return matchc;
    }

    public static float matchEmail(String first, String second) {
        String shortstr;
        String longstr;
        int sc;
        String secondName;
        float matchc = 0.0f;
        if (first == null || second == null) {
            return matchc;
        }
        if (first.equalsIgnoreCase(second)) {
            return 1.0f;
        }
        String firstName = first.split("@", 2)[0].toLowerCase();
        if (firstName.equals(secondName = second.split("@", 2)[0].toLowerCase())) {
            return 0.9f;
        }
        int fc = firstName.length();
        int commonc = fc > (sc = secondName.length()) ? sc : fc;
        int[] matchedI = new int[commonc];
        if (fc > sc) {
            longstr = firstName;
            shortstr = secondName;
        } else {
            longstr = secondName;
            shortstr = firstName;
        }
        for (int i = 0; i < commonc; ++i) {
            char c = shortstr.charAt(i);
            int j = shortstr.indexOf(c);
            int startI = 0;
            while (j < i) {
                startI = matchedI[j];
                j = shortstr.indexOf(c, j);
            }
            if (j != i) continue;
            matchedI[i] = longstr.indexOf(c, startI);
        }
        matchc = StringCaseFormatUtil.showMatchval(matchedI);
        return matchc;
    }

    public static float showMatchval(int[] matchedA) {
        float matchval = 0.0f;
        int matchlen = matchedA.length;
        int prevVal = -1;
        int matchC = 0;
        int seqC = 0;
        for (int i = 0; i < matchlen; ++i) {
            if (matchedA[i] == -1) continue;
            ++matchC;
            if (matchedA[i] != prevVal + 1) continue;
            ++seqC;
        }
        matchval = (float)matchC / (float)matchlen * 0.5f + (float)seqC / (float)matchlen * 0.4f;
        return matchval;
    }

    public static Vector<String> tokenizeText(String text, String token) {
        if (token == null || text == null || "".equals(text) || "".equals(token)) {
            return null;
        }
        String[] tokenA = text.trim().split(token);
        int i = 0;
        Vector<String> vec = new Vector<String>();
        while (i < tokenA.length) {
            vec.add(tokenA[i++]);
        }
        return vec;
    }

    public static String digitString(String numString) {
        String onlyDigit = "";
        if (numString == null || "".equals(numString)) {
            return onlyDigit;
        }
        int strlen = numString.length();
        for (int i = 0; i < strlen; ++i) {
            char c = numString.charAt(i);
            if (!Character.isDigit(c)) continue;
            onlyDigit = onlyDigit + c;
        }
        return onlyDigit;
    }
}

