/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.HashSet;
import java.util.Set;
import org.simmetrics.SetMetric;

public class DiceSimilarity<T>
implements SetMetric<T> {
    @Override
    public float compare(Set<T> a, Set<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        HashSet<T> all = new HashSet<T>();
        all.addAll(a);
        all.addAll(b);
        int commonTerms = a.size() + b.size() - all.size();
        return 2.0f * (float)commonTerms / (float)(a.size() + b.size());
    }

    public String toString() {
        return "DiceSimilarity";
    }
}

