/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.collect.HashMultiset;
import java.util.List;
import org.simmetrics.ListMetric;

public class MatchingCoefficient<T>
implements ListMetric<T> {
    @Override
    public float compare(List<T> a, List<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        int intersection = 0;
        HashMultiset bCopy = HashMultiset.create(b);
        for (T token : a) {
            if (!bCopy.remove(token)) continue;
            ++intersection;
        }
        return (float)intersection / (float)(a.size() + b.size() - intersection);
    }

    public String toString() {
        return "MatchingCoefficient";
    }
}

