/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.simplifiers;

import java.util.Locale;
import org.simmetrics.simplifiers.Simplifier;

public abstract class Case
implements Simplifier {

    public static class Upper
    extends Case {
        private final Locale locale;

        public Upper(Locale locale) {
            this.locale = locale;
        }

        public Upper() {
            this.locale = Locale.getDefault();
        }

        @Override
        public String simplify(String s) {
            return s.toUpperCase(this.locale);
        }

        public String toString() {
            return "Upper [locale=" + this.locale + "]";
        }
    }

    public static class Lower
    extends Case {
        private final Locale locale;

        public Lower(Locale locale) {
            this.locale = locale;
        }

        public Lower() {
            this.locale = Locale.getDefault();
        }

        @Override
        public String simplify(String s) {
            return s.toLowerCase(this.locale);
        }

        public String toString() {
            return "Lower [locale=" + this.locale + "]";
        }
    }
}

