/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.tokenizers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import org.simmetrics.tokenizers.AbstractTokenizer;
import org.simmetrics.tokenizers.QGram;

public class QGramExtended
extends AbstractTokenizer {
    private static final String DEFAULT_START_PADDING = "#";
    private static final String DEFAULT_END_PADDING = "#";
    private final String endPadding;
    private final String startPadding;
    private final QGram tokenizer;

    public QGramExtended(int q, String startPadding, String endPadding) {
        Preconditions.checkArgument((!startPadding.isEmpty() ? 1 : 0) != 0, (Object)"startPadding may not be empty");
        Preconditions.checkArgument((!endPadding.isEmpty() ? 1 : 0) != 0, (Object)"endPadding may not be empty");
        this.tokenizer = new QGram(q);
        this.startPadding = Strings.repeat((String)startPadding, (int)(q - 1));
        this.endPadding = Strings.repeat((String)endPadding, (int)(q - 1));
    }

    public QGramExtended(int q) {
        this(q, "#", "#");
    }

    public String getStartPadding() {
        return this.startPadding;
    }

    public String getEndPadding() {
        return this.endPadding;
    }

    @Override
    public List<String> tokenizeToList(String input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        return this.tokenizer.tokenizeToList(this.startPadding + input + this.endPadding);
    }

    public String toString() {
        return "QGramExtendedTokenizer [startPadding=" + this.startPadding + ", endPadding=" + this.endPadding + ", q=" + this.tokenizer.getQ() + "]";
    }
}

