/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.StringProfile;
import info.debatty.java.stringsimilarity.StringSet;
import info.debatty.java.utils.SparseBooleanVector;
import info.debatty.java.utils.SparseIntegerVector;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KShingling {
    protected int k;
    private final HashMap<String, Integer> shingles = new HashMap();
    private static final Pattern spaceReg = Pattern.compile("\\s+");

    public static void main(String[] args) {
        String s1 = "my string,  \n  my song";
        String s2 = "another string, from a song";
        KShingling ks = new KShingling(4);
        System.out.println(ks.getProfile(s1));
        System.out.println(ks.getProfile(s2));
        ks = new KShingling(2);
        System.out.println(ks.getProfile("ABCAB"));
        System.out.println(ks.getArrayProfile("ABCAB"));
    }

    public KShingling() {
        this.k = 5;
    }

    public KShingling(int k) {
        if (k <= 0) {
            throw new InvalidParameterException("k should be positive!");
        }
        this.k = k;
    }

    public int getK() {
        return this.k;
    }

    int[] getArrayProfile(String s) {
        ArrayList<Integer> r = new ArrayList<Integer>(this.shingles.size());
        for (int i = 0; i < this.shingles.size(); ++i) {
            r.add(0);
        }
        s = spaceReg.matcher(s).replaceAll(" ");
        for (int i = 0; i < s.length() - this.k + 1; ++i) {
            String shingle = s.substring(i, i + this.k);
            if (this.shingles.containsKey(shingle)) {
                int position = this.shingles.get(shingle);
                r.set(position, r.get(position) + 1);
                continue;
            }
            this.shingles.put(shingle, this.shingles.size());
            r.add(1);
        }
        return KShingling.convertIntegers(r);
    }

    private static int[] convertIntegers(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    public StringProfile getProfile(String s) {
        HashMap<Integer, Integer> hash_profile = this.getHashProfile(s);
        return new StringProfile(new SparseIntegerVector(hash_profile), this);
    }

    public StringSet getSet(String s) {
        HashMap<Integer, Integer> hash_profile = this.getHashProfile(s);
        return new StringSet(new SparseBooleanVector(hash_profile), this);
    }

    public int getDimension() {
        return this.shingles.size();
    }

    private HashMap<Integer, Integer> getHashProfile(String s) {
        HashMap<Integer, Integer> hash_profile = new HashMap<Integer, Integer>(s.length());
        s = spaceReg.matcher(s).replaceAll(" ");
        for (int i = 0; i < s.length() - this.k + 1; ++i) {
            int position;
            String shingle = s.substring(i, i + this.k);
            if (this.shingles.containsKey(shingle)) {
                position = this.shingles.get(shingle);
            } else {
                position = this.shingles.size();
                this.shingles.put(shingle, this.shingles.size());
            }
            if (hash_profile.containsKey(position)) {
                hash_profile.put(position, hash_profile.get(position) + 1);
                continue;
            }
            hash_profile.put(position, 1);
        }
        return hash_profile;
    }

    String getNGram(int key) {
        for (Map.Entry<String, Integer> entry : this.shingles.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            return entry.getKey();
        }
        throw new InvalidParameterException("No ngram coresponds to key " + key);
    }
}

