/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simmetrics.ListMetric;

public class EuclideanDistance<T>
implements ListMetric<T> {
    @Override
    public float compare(List<T> a, List<T> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        float totalPossible = (float)Math.sqrt(a.size() * a.size() + b.size() * b.size());
        return (totalPossible - EuclideanDistance.distance(a, b)) / totalPossible;
    }

    private static <T> float distance(List<T> a, List<T> b) {
        HashSet<T> all = new HashSet<T>();
        all.addAll(a);
        all.addAll(b);
        float totalDistance = 0.0f;
        for (Object token : all) {
            int frequencyInA = Collections.frequency(a, token);
            int frequencyInB = Collections.frequency(b, token);
            totalDistance += (float)((frequencyInA - frequencyInB) * (frequencyInA - frequencyInB));
        }
        return (float)Math.sqrt(totalDistance);
    }

    public String toString() {
        return "EuclideanDistance";
    }
}

