/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;

public class NeedlemanWunch
implements StringMetric {
    private static final Substitution MATCH_0_MISMATCH_1 = new MatchMismatch(0.0f, -1.0f);
    private final Substitution substitution;
    private final float gapValue;

    public NeedlemanWunch() {
        this(-2.0f, MATCH_0_MISMATCH_1);
    }

    public NeedlemanWunch(float gapValue, Substitution substitution) {
        Preconditions.checkArgument((gapValue <= 0.0f ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)substitution);
        this.gapValue = gapValue;
        this.substitution = substitution;
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        float maxDistance = (float)Math.max(a.length(), b.length()) * Math.max(this.substitution.max(), this.gapValue);
        float minDistance = (float)Math.max(a.length(), b.length()) * Math.min(this.substitution.min(), this.gapValue);
        return (-this.needlemanWunch(a, b) - minDistance) / (maxDistance - minDistance);
    }

    private float needlemanWunch(String s, String t) {
        if (Objects.equals(s, t)) {
            return 0.0f;
        }
        if (s.isEmpty()) {
            return t.length();
        }
        if (t.isEmpty()) {
            return s.length();
        }
        float[] v0 = new float[t.length() + 1];
        float[] v1 = new float[t.length() + 1];
        for (int j = 0; j < v0.length; ++j) {
            v0[j] = j;
        }
        for (int i = 1; i < s.length() + 1; ++i) {
            int j;
            v1[0] = i;
            for (j = 1; j < v0.length; ++j) {
                v1[j] = org.simmetrics.utils.Math.min3(v0[j] - this.gapValue, v1[j - 1] - this.gapValue, v0[j - 1] - this.substitution.compare(s, i - 1, t, j - 1));
            }
            for (j = 0; j < v0.length; ++j) {
                v0[j] = v1[j];
            }
        }
        return v1[v1.length - 1];
    }

    public String toString() {
        return "NeedlemanWunch [costFunction=" + this.substitution + ", gapCost=" + this.gapValue + "]";
    }
}

