/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.base.Preconditions;
import org.simmetrics.Metric;
import org.simmetrics.StringMetric;
import org.simmetrics.simplifiers.Simplifier;

public final class CompositeStringMetric
implements StringMetric {
    private final Simplifier simplifier;
    private final Metric<String> metric;

    public CompositeStringMetric(Metric<String> metric, Simplifier simplifier) {
        Preconditions.checkNotNull(metric);
        Preconditions.checkNotNull((Object)simplifier);
        this.metric = metric;
        this.simplifier = simplifier;
    }

    @Override
    public float compare(String a, String b) {
        return this.metric.compare(this.simplifier.simplify(a), this.simplifier.simplify(b));
    }

    public String toString() {
        return this.metric + " [" + this.simplifier + "]";
    }
}

