/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simmetrics.tokenizers.Tokenizer;

public final class CompositeTokenizer
implements Tokenizer {
    private final Iterable<Tokenizer> tokenizers;

    public CompositeTokenizer(Iterable<Tokenizer> tokenizers) {
        this.tokenizers = tokenizers;
    }

    @Override
    public List<String> tokenizeToList(String input) {
        ArrayList<String> tokens = new ArrayList<String>(1);
        tokens.add(input);
        ArrayList<String> newTokens = new ArrayList<String>(input.length());
        for (Tokenizer t : this.tokenizers) {
            for (String token : tokens) {
                newTokens.addAll(t.tokenizeToList(token));
            }
            tokens = newTokens;
            newTokens = new ArrayList(input.length());
        }
        return tokens;
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        HashSet<String> tokens = new HashSet<String>(1);
        tokens.add(input);
        HashSet<String> newTokens = new HashSet<String>(input.length());
        for (Tokenizer t : this.tokenizers) {
            for (String token : tokens) {
                newTokens.addAll(t.tokenizeToList(token));
            }
            tokens = newTokens;
            newTokens = new HashSet(input.length());
        }
        return tokens;
    }

    public String toString() {
        return Joiner.on((String)" -> ").join(this.tokenizers);
    }
}

