/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.simmetrics.tokenizers.Tokenizer;

public final class FilteringTokenizer
implements Tokenizer {
    private final Tokenizer tokenizer;
    private final Predicate<String> filter;

    public FilteringTokenizer(Tokenizer tokenizer, Predicate<String> predicate) {
        Preconditions.checkNotNull(predicate);
        this.filter = predicate;
        this.tokenizer = tokenizer;
    }

    public ArrayList<String> tokenizeToList(String input) {
        return new ArrayList<String>(Collections2.filter(this.tokenizer.tokenizeToList(input), this.filter));
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        return new HashSet<String>(Collections2.filter(this.tokenizer.tokenizeToSet(input), this.filter));
    }

    public String toString() {
        return Joiner.on((String)" -> ").join((Object)this.tokenizer, this.filter, new Object[0]);
    }
}

