/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.clustering.centroid.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import net.sf.jdmf.algorithms.clustering.centroid.InitialCentroidChoiceStrategy;
import net.sf.jdmf.util.MathCalculator;

public class FirstRandomOthersDistantChoiceStrategy
implements InitialCentroidChoiceStrategy {
    private MathCalculator mathCalculator = new MathCalculator();

    @Override
    public List<Vector<Double>> chooseInitialCentroids(List<Vector<Double>> points, Integer numberOfClusters) {
        Random random = new Random();
        Vector<Double> firstClusterCentroid = points.get(random.nextInt(points.size()));
        ArrayList<Vector<Double>> initialCentroids = new ArrayList<Vector<Double>>();
        initialCentroids.add(firstClusterCentroid);
        for (int i = 1; i < numberOfClusters; ++i) {
            Vector<Double> nextClusterCentroid = null;
            Double highestDistanceSumFromPreviousClusterCentroids = 0.0;
            for (Vector<Double> point : points) {
                Double distanceSumFromPreviousClusterCentroids = 0.0;
                for (Vector vector : initialCentroids) {
                    distanceSumFromPreviousClusterCentroids = distanceSumFromPreviousClusterCentroids + this.mathCalculator.calculateDistance(point, vector);
                }
                if (!(distanceSumFromPreviousClusterCentroids > highestDistanceSumFromPreviousClusterCentroids)) continue;
                nextClusterCentroid = point;
                highestDistanceSumFromPreviousClusterCentroids = distanceSumFromPreviousClusterCentroids;
            }
            initialCentroids.add(nextClusterCentroid);
        }
        return initialCentroids;
    }
}

