/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.data.output;

import java.util.List;
import java.util.Stack;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.operators.LogicalOperator;
import net.sf.jdmf.data.output.Evaluable;
import net.sf.jdmf.data.output.RuleElement;

public abstract class AbstractRuleElementEvaluable
implements Evaluable {
    protected boolean evaluateRuleElements(List<RuleElement> ruleElements, Instance instance) {
        Stack<Boolean> evaluationStack = new Stack<Boolean>();
        for (RuleElement ruleElement : ruleElements) {
            evaluationStack.push(ruleElement.evaluate(instance));
            if (evaluationStack.size() != 2) continue;
            boolean secondEvaluationResult = (Boolean)evaluationStack.pop();
            boolean firstEvaluationResult = (Boolean)evaluationStack.pop();
            LogicalOperator logicalOperator = ruleElement.getLogicalOperator();
            evaluationStack.push(logicalOperator.evaluate(firstEvaluationResult, secondEvaluationResult));
        }
        if (evaluationStack.isEmpty()) {
            return true;
        }
        return (Boolean)evaluationStack.pop();
    }
}

