/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.arrah.framework.analytics.PIIValidator;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;
import org.arrah.framework.util.StringCaseFormatUtil;
import org.simmetrics.metrics.JaroWinkler;

public class MetadataMatcher {
    private Hashtable<String, String> _ht;
    private confidenceL confidenceLevel;

    public MetadataMatcher() {
        this._ht = new Hashtable();
    }

    public MetadataMatcher(Hashtable<String, String> ht) {
        this._ht = ht;
    }

    public String[] getCSValue(String key) {
        String val = this._ht.get(key);
        if (val == null || "".equals(val)) {
            return new String[]{""};
        }
        String[] newval = val.split(",");
        return newval;
    }

    public void addnewValue(String key, String value) {
        if (key == null || "".equals(key) || value == null) {
            return;
        }
        String val = this._ht.get(key);
        val = val + "," + value;
        this._ht.put(key, val);
    }

    public void deleteValue(String key, String value) {
        String newval = "";
        String[] val = this.getCSValue(key);
        for (int i = 0; i < val.length; ++i) {
            if (val[i].equalsIgnoreCase(value)) continue;
            newval = newval.equals("") ? val[i] : newval + "," + val[i];
        }
        this._ht.put(key, newval);
    }

    public Hashtable<String, String> showKeyValueAsTable() {
        return this._ht;
    }

    public Vector<String> matchedKeys(String colName, float nearness) {
        JaroWinkler simAlgo = new JaroWinkler();
        Vector<String> matchV = new Vector<String>();
        Enumeration<String> e = this._ht.keys();
        while (e.hasMoreElements()) {
            String[] val;
            String key = e.nextElement();
            for (String newval : val = this.getCSValue(key)) {
                float simI = simAlgo.compare(newval.toLowerCase(), colName.toLowerCase());
                if (!(simI >= nearness) || matchV.indexOf(key) != -1) continue;
                matchV.add(key);
            }
        }
        return matchV;
    }

    public Hashtable<String, Vector<String>> matchedKeys(String[] colName, float nearness) {
        Hashtable<String, Vector<String>> newVal = new Hashtable<String, Vector<String>>();
        for (String val : colName) {
            Vector<String> matchV = this.matchedKeys(val, nearness);
            newVal.put(val, matchV);
        }
        return newVal;
    }

    public Hashtable<String, String> tableAsFlatKey() {
        Hashtable<String, String> newht = new Hashtable<String, String>();
        Enumeration<String> e = this._ht.keys();
        while (e.hasMoreElements()) {
            String[] val;
            String key = e.nextElement();
            for (String newval : val = this.getCSValue(key)) {
                newht.put(newval, key);
            }
        }
        return newht;
    }

    public Object[] getPIIColData(Object table, String col, String piigrp, Object[] colD) {
        int datamatchCount = 0;
        if (table instanceof String) {
            colD = this.getDataforCol(table.toString(), col);
        } else if (table instanceof ReportTableModel) {
            colD = ((ReportTableModel)table).getColDataRandom(col, 10);
        } else {
            System.out.println("Table Type not recognised.");
            return colD;
        }
        PIIValidator piiv = new PIIValidator();
        for (int i = 0; i < colD.length; ++i) {
            Object s = colD[i];
            if (s == null) continue;
            boolean isMatch = false;
            String onlyd = StringCaseFormatUtil.digitString(s.toString());
            switch (piigrp) {
                case "CreditCard": {
                    isMatch = piiv.isCreditCard(onlyd);
                    break;
                }
                case "SocialSecurity": {
                    isMatch = piiv.isSSN(onlyd);
                    break;
                }
                case "DoB": {
                    if (!(s instanceof Date)) break;
                    isMatch = piiv.isDoB((Date)s);
                    break;
                }
                case "Email": {
                    isMatch = piiv.isEmail(s.toString());
                    break;
                }
                case "PhoneNum": {
                    isMatch = piiv.isPhone(onlyd);
                    break;
                }
            }
            if (!isMatch) continue;
            ++datamatchCount;
        }
        if (datamatchCount < 5) {
            this.setConfidenceLevel(confidenceL.Low);
        } else if (datamatchCount < 9) {
            this.setConfidenceLevel(confidenceL.Medium);
        } else {
            this.setConfidenceLevel(confidenceL.High);
        }
        return colD;
    }

    public Object[] getDataforCol(String table, String col) {
        Object[] coldata = new Object[10];
        QueryBuilder querybuilder = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), table, col, Rdbms_conn.getDBType());
        String top_sel_query = querybuilder.top_query(true, "top_count", "10");
        try {
            Rdbms_conn.openConn();
            ResultSet rs = Rdbms_conn.runQuery(top_sel_query);
            int counter = 0;
            while (rs.next() && counter < 10) {
                Object top_val = rs.getObject("top_count");
                coldata[counter++] = top_val;
            }
            rs.close();
            Rdbms_conn.closeConn();
        }
        catch (SQLException exp) {
            System.out.println("Column fetch error:" + exp.getLocalizedMessage());
            return coldata;
        }
        return coldata;
    }

    public String getConfidenceLevel() {
        return this.confidenceLevel.toString();
    }

    public void setConfidenceLevel(confidenceL confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    private static enum confidenceL {
        Low,
        Medium,
        High;

    }
}

