/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class RandomColGen {
    private int _rowC = 0;

    public RandomColGen(int rowc) {
        this._rowC = rowc;
    }

    public RandomColGen() {
    }

    public int getColCount() {
        return this._rowC;
    }

    public void setColCount(int rowc) {
        this._rowC = rowc;
    }

    public Vector<Long> updateColumnRandomInt(long max, long min) {
        Random rd = new Random();
        Vector<Long> _vc = new Vector<Long>();
        for (int i = 0; i < this._rowC; ++i) {
            double rdGen = rd.nextDouble();
            double res = (double)min + (double)(max - min) * ((1.0 - rdGen) / 1.0);
            _vc.add(Math.round(res));
        }
        return _vc;
    }

    public Vector<Double> updateColumnRandomDouble(long max, long min) {
        Random rd = new Random();
        Vector<Double> _vc = new Vector<Double>();
        for (int i = 0; i < this._rowC; ++i) {
            double rdGen = rd.nextDouble();
            double res = (double)min + (double)(max - min) * ((1.0 - rdGen) / 1.0);
            _vc.add(res);
        }
        return _vc;
    }

    public static Double randomDouble(double max, double min) {
        Random rd = new Random();
        double rdGen = rd.nextDouble();
        double res = min + (max - min) * ((1.0 - rdGen) / 1.0);
        return res;
    }

    public Vector<Date> updateColumnRandomDate(long max, long min) {
        Random rd = new Random();
        Vector<Date> _vc = new Vector<Date>();
        for (int i = 0; i < this._rowC; ++i) {
            double rdGen = rd.nextDouble();
            double res = (double)min + (double)(max - min) * ((1.0 - rdGen) / 1.0);
            _vc.add(new Date(Math.round(res)));
        }
        return _vc;
    }

    public Vector<String> updateColumnRandomString(long maxL, long minL, int lan, int type) {
        int minCodePoint = this.getRangeOfUnicode(lan, true);
        int maxCodePoint = this.getRangeOfUnicode(lan, false);
        System.out.println("\n Information: Make sure fonts are available for selected language");
        System.out.println("\n or Character may not appear.");
        Vector<String> _vc = new Vector<String>();
        Random rd = new Random();
        for (int i = 0; i < this._rowC; ++i) {
            String repS = "";
            int currCount = 0;
            int degCount = (int)minL + rd.nextInt((int)maxL - (int)minL);
            while (currCount < degCount) {
                char[] rep;
                int codeP = minCodePoint + new Integer(rd.nextInt(maxCodePoint - minCodePoint));
                if (Character.isISOControl(codeP) || type == 1 && !Character.isLetterOrDigit(codeP) || type == 2 && !Character.isLetter(codeP) || type == 3 && !Character.isDigit(codeP)) continue;
                if (repS.equals("") && Character.isJavaIdentifierStart(codeP)) {
                    rep = Character.toChars(codeP);
                    repS = repS + new String(rep);
                    ++currCount;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(codeP)) continue;
                rep = Character.toChars(codeP);
                repS = repS + new String(rep);
                ++currCount;
            }
            _vc.add(new String(repS));
        }
        return _vc;
    }

    private int getRangeOfUnicode(int lan, boolean lower) {
        switch (lan) {
            case 0: {
                if (lower) {
                    return 0;
                }
                return 127;
            }
            case 1: {
                if (lower) {
                    return 880;
                }
                return 1023;
            }
            case 2: {
                if (lower) {
                    return 1424;
                }
                return 1535;
            }
            case 3: {
                if (lower) {
                    return 1536;
                }
                return 1791;
            }
            case 4: {
                if (lower) {
                    return 2304;
                }
                return 2431;
            }
            case 5: {
                if (lower) {
                    return 2944;
                }
                return 3071;
            }
            case 6: {
                if (lower) {
                    return 3200;
                }
                return 3327;
            }
            case 7: {
                if (lower) {
                    return 3584;
                }
                return 3711;
            }
            case 8: {
                if (lower) {
                    return 4352;
                }
                return 4607;
            }
            case 9: {
                if (lower) {
                    return 12352;
                }
                return 12447;
            }
            case 10: {
                if (lower) {
                    return 12448;
                }
                return 12543;
            }
            case 11: {
                if (lower) {
                    return 12544;
                }
                return 12591;
            }
            case 12: {
                if (lower) {
                    return 12688;
                }
                return 12703;
            }
        }
        if (lower) {
            return 0;
        }
        return 65535;
    }

    public static Object[] burstData(Object[] colObj, int colC) {
        if (colObj == null || colObj.length >= colC) {
            return colObj;
        }
        Object[] newObj = new Object[colC];
        for (int i = 0; i < colC; ++i) {
            int rand = new Random().nextInt(colObj.length);
            newObj[i] = colObj[rand];
        }
        return newObj;
    }
}

