/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.arrah.framework.dataquality.RecordMatch;

public class StringMergeUtil {
    public static String aggrString(ArrayList<String> list, int action) {
        double result = 0.0;
        for (String a : list) {
            if (a == null || "".equals(a)) continue;
            try {
                double dv = Double.parseDouble(a);
                switch (action) {
                    case 1: {
                        result += dv;
                        break;
                    }
                    case 2: {
                        result += 1.0;
                        break;
                    }
                    case 3: {
                        if (!(result > dv)) break;
                        result = dv;
                        break;
                    }
                    case 4: {
                        if (!(result < dv)) break;
                        result = dv;
                        break;
                    }
                }
            }
            catch (Exception pe) {
                if (action == 2) {
                    result += 1.0;
                    continue;
                }
                System.out.println("Format Exception for Number:" + a);
            }
        }
        return new Double(result).toString();
    }

    public static String aggrAvgString(ArrayList<String> list) {
        double result = 0.0;
        String sumStr = StringMergeUtil.aggrString(list, 1);
        double dv = Double.parseDouble(sumStr);
        if (list.size() == 0) {
            return new Double(result).toString();
        }
        return new Double(dv / (double)list.size()).toString();
    }

    public static HashMap<String, Integer> freqCount(ArrayList<String> list) {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        for (String a : list) {
            if (h.containsKey(a)) {
                int count = h.get(a);
                h.put(a, ++count);
                continue;
            }
            h.put(a, 1);
        }
        return h;
    }

    public static HashMap<String, Integer> strLenCount(ArrayList<String> list) {
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        for (String a : list) {
            int strLen = a.length();
            h.put(a, strLen);
        }
        return h;
    }

    public static ArrayList<String> topValueList(HashMap<String, Integer> mapList) {
        ArrayList<String> result = new ArrayList<String>();
        int maxVal = 0;
        for (String keyStr : mapList.keySet()) {
            int val = mapList.get(keyStr);
            if (val > maxVal) {
                result.removeAll(result);
                result.add(keyStr);
                maxVal = val;
                continue;
            }
            if (val != maxVal) continue;
            result.add(keyStr);
        }
        return result;
    }

    public static String mergeValue(ArrayList<String> list) {
        float weightage;
        int val;
        int i;
        String result = "";
        int topFreqVal = 0;
        int topStrVal = 0;
        float maxweightage = 0.0f;
        HashMap<String, Integer> freqCountHash = StringMergeUtil.freqCount(list);
        HashMap<String, Integer> strLenCountHash = StringMergeUtil.strLenCount(list);
        ArrayList<String> freqVal = StringMergeUtil.topValueList(freqCountHash);
        ArrayList<String> strLenVal = StringMergeUtil.topValueList(strLenCountHash);
        topFreqVal = freqCountHash.get(freqVal.get(0));
        topStrVal = strLenCountHash.get(strLenVal.get(0));
        if (topStrVal > 0) {
            for (i = 0; i < freqVal.size(); ++i) {
                val = strLenCountHash.get(freqVal.get(i));
                weightage = (float)val / (float)topStrVal;
                if (!(weightage > maxweightage)) continue;
                result = (String)freqVal.get(i);
                maxweightage = weightage;
            }
        }
        if (topFreqVal > 0) {
            for (i = 0; i < strLenVal.size(); ++i) {
                val = freqCountHash.get(strLenVal.get(i));
                weightage = (float)val / (float)topFreqVal;
                if (!(weightage > maxweightage)) continue;
                result = (String)strLenVal.get(i);
                maxweightage = weightage;
            }
        }
        return result;
    }

    public static ArrayList<ArrayList<String>> transposeValue(ArrayList<String[]> list) {
        int j;
        int i;
        int row = list.size();
        String[] firstVal = list.get(0);
        int column = firstVal.length;
        String[][] newStorage = new String[column][row];
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (i = 0; i < list.size(); ++i) {
            String[] val = list.get(i);
            for (j = 0; j < column; ++j) {
                if (val[j] == null) {
                    val[j] = "";
                }
                newStorage[j][i] = val[j];
            }
        }
        for (i = 0; i < column; ++i) {
            ArrayList<String> col = new ArrayList<String>();
            for (j = 0; j < row; ++j) {
                col.add(newStorage[i][j]);
            }
            result.add(col);
        }
        return result;
    }

    public static String[] getGoldenValue(ArrayList<String[]> list, Integer[] actionType) {
        ArrayList<ArrayList<String>> trasVal = StringMergeUtil.transposeValue(list);
        String[] result = new String[trasVal.size()];
        for (int i = 0; i < trasVal.size(); ++i) {
            ArrayList<String> col = trasVal.get(i);
            int action = actionType[i];
            String goldVal = "";
            switch (action) {
                case 0: {
                    break;
                }
                case 1: {
                    String a;
                    Iterator<String> iterator = col.iterator();
                    while (iterator.hasNext() && ((goldVal = (a = iterator.next())) == null || "".equals(goldVal))) {
                    }
                    break;
                }
                case 2: {
                    String a;
                    HashMap<String, Integer> freqCountHash = StringMergeUtil.freqCount(col);
                    ArrayList<String> freqVal = StringMergeUtil.topValueList(freqCountHash);
                    Iterator iterator = freqVal.iterator();
                    while (iterator.hasNext() && ((goldVal = (a = (String)iterator.next())) == null || "".equals(goldVal))) {
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    goldVal = StringMergeUtil.aggrString(col, action - 2);
                    break;
                }
                case 7: {
                    goldVal = StringMergeUtil.aggrAvgString(col);
                    break;
                }
                case 100: {
                    goldVal = StringMergeUtil.mergeValue(col);
                    break;
                }
            }
            result[i] = goldVal;
        }
        return result;
    }

    public static HashMap<List<String>, List<String>> innerJoinResult(List<RecordMatch.Result> resultSet) {
        int prevIndex = -1;
        float simMatchIndex = 0.0f;
        HashMap<List<String>, List<String>> innerJoinHM = new HashMap<List<String>, List<String>>();
        HashMap<Integer, Integer> leftRightMap = new HashMap<Integer, Integer>();
        for (RecordMatch.Result res : resultSet) {
            if (!res.isMatch()) continue;
            int leftI = res.getLeftMatchIndex();
            int rightI = res.getRightMatchIndex();
            List<String> leftrow = res.getLeftMatchedRow();
            List<String> rightrow = res.getRightMatchedRow();
            float simMatchVal = res.getSimMatchVal();
            if (leftI != prevIndex) {
                prevIndex = leftI;
                if (leftRightMap.containsValue(rightI)) continue;
                simMatchIndex = simMatchVal;
                innerJoinHM.put(leftrow, rightrow);
                leftRightMap.put(leftI, rightI);
                continue;
            }
            if (leftRightMap.containsValue(rightI) || !(simMatchVal > simMatchIndex)) continue;
            simMatchIndex = simMatchVal;
            innerJoinHM.put(leftrow, rightrow);
            leftRightMap.put(leftI, rightI);
        }
        return innerJoinHM;
    }
}

