/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;
import org.arrah.framework.ndtable.ReportTableModel;

public class AsciiParser {
    public static ArrayList<String> delims = new ArrayList();

    public void init(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(AsciiParser.class.getClassLoader().getResourceAsStream(fileName)));
        int ctr = 1;
        String sCurrentLine = null;
        String delimadd = "";
        while ((sCurrentLine = br.readLine()) != null) {
            if (ctr % 5 == 4) {
                delimadd = sCurrentLine + " : ";
            } else if (ctr % 5 == 0) {
                delimadd = delimadd + sCurrentLine;
                delims.add(delimadd);
                delimadd = "";
            }
            ++ctr;
        }
        br.close();
    }

    public static ReportTableModel loadRecord(File f, String rsp, String fsp, int noCol, boolean isEditable) {
        String[] colName = new String[noCol];
        for (int i = 0; i < noCol; ++i) {
            colName[i] = "ColName_" + i;
        }
        ReportTableModel rtm = new ReportTableModel(colName, isEditable);
        String[] col = new String[noCol];
        int validLine = 0;
        try {
            Scanner s = null;
            s = rsp == null || rsp.equals("") ? new Scanner(f).useDelimiter(fsp) : new Scanner(f).useDelimiter(rsp);
            if (rsp == null || rsp.equals("") || fsp.equals(rsp)) {
                int index = 0;
                while (s.hasNext() && (validLine <= 100 || isEditable)) {
                    String record = s.next();
                    if (index < noCol - 1) {
                        col[index] = record;
                        ++index;
                        continue;
                    }
                    if (index != noCol - 1) continue;
                    col[index] = record;
                    index = 0;
                    rtm.addFillRow(col);
                    ++validLine;
                }
            } else {
                while (s.hasNext() && (validLine <= 100 || isEditable)) {
                    int i;
                    String record = s.next();
                    String[] newCol = record.split(fsp);
                    if (newCol.length == colName.length) {
                        rtm.addFillRow(newCol);
                        ++validLine;
                        continue;
                    }
                    if (newCol.length > colName.length) {
                        for (i = 0; i < col.length; ++i) {
                            col[i] = newCol[i];
                        }
                        rtm.addFillRow(col);
                        ++validLine;
                        continue;
                    }
                    for (i = 0; i < newCol.length; ++i) {
                        col[i] = newCol[i];
                    }
                    for (i = newCol.length; i < colName.length; ++i) {
                        col[i] = "";
                    }
                    rtm.addFillRow(col);
                    ++validLine;
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found:" + e);
        }
        return rtm;
    }
}

