/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity.examples;

import info.debatty.java.utils.SparseDoubleVector;
import java.util.Random;

public class SparseDoubleVectorExample {
    public static void main(String[] args) {
        int i;
        int j;
        int count = 400;
        int size = 1000;
        double threshold = 0.7;
        System.out.println("Create some random SparseDoubleVector...");
        Random r = new Random();
        SparseDoubleVector[] data = new SparseDoubleVector[count];
        for (int i2 = 0; i2 < count; ++i2) {
            double[] v = new double[size];
            for (j = 0; j < size; ++j) {
                v[j] = r.nextDouble();
            }
            data[i2] = new SparseDoubleVector(v);
        }
        System.out.println("Compute real similarities...");
        double[][] real_similarities = new double[count][count];
        for (i = 0; i < count; ++i) {
            for (j = 0; j < i; ++j) {
                real_similarities[i][j] = data[i].cosineSimilarity(data[j]);
            }
        }
        System.out.println("Downsample the vectors using DIMSUM algorithm...");
        for (i = 0; i < count; ++i) {
            try {
                data[i].sampleDIMSUM(threshold, count, size);
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
        System.out.println("Compute estimated similarities...");
        int above_threshold = 0;
        int correct = 0;
        for (int i3 = 0; i3 < count; ++i3) {
            for (int j2 = 0; j2 < i3; ++j2) {
                double sim = data[i3].cosineSimilarity(data[j2]);
                if (!(real_similarities[i3][j2] >= threshold)) continue;
                ++above_threshold;
                if (!(Math.abs(real_similarities[i3][j2] - sim) / real_similarities[i3][j2] < 0.2)) continue;
                ++correct;
            }
        }
        System.out.println("Above threshold: " + above_threshold);
        System.out.println("Correct (max relative error 20%)" + correct);
        System.out.println("(" + Math.round(100.0 * (double)correct / (double)above_threshold) + "%)");
    }
}

