/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics;

import java.util.List;
import org.simmetrics.StringMetric;
import org.simmetrics.StringMetricBuilder;
import org.simmetrics.metrics.BlockDistance;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.DiceSimilarity;
import org.simmetrics.metrics.EuclideanDistance;
import org.simmetrics.metrics.JaccardSimilarity;
import org.simmetrics.metrics.Jaro;
import org.simmetrics.metrics.JaroWinkler;
import org.simmetrics.metrics.Levenshtein;
import org.simmetrics.metrics.MatchingCoefficient;
import org.simmetrics.metrics.MongeElkan;
import org.simmetrics.metrics.NeedlemanWunch;
import org.simmetrics.metrics.OverlapCoefficient;
import org.simmetrics.metrics.SimonWhite;
import org.simmetrics.metrics.SmithWaterman;
import org.simmetrics.metrics.SmithWatermanGotoh;
import org.simmetrics.simplifiers.Soundex;
import org.simmetrics.tokenizers.QGram;
import org.simmetrics.tokenizers.QGramExtended;
import org.simmetrics.tokenizers.Whitespace;

public final class StringMetrics {
    private StringMetrics() {
    }

    public static final float[] compare(StringMetric metric, String c, List<String> strings) {
        float[] results = new float[strings.size()];
        int i = 0;
        for (String s : strings) {
            results[i++] = metric.compare(c, s);
        }
        return results;
    }

    public static final float[] compare(StringMetric metric, String c, String ... strings) {
        float[] results = new float[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            results[i] = metric.compare(c, strings[i]);
        }
        return results;
    }

    public static final float[] compareArrays(StringMetric metric, String[] a, String[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("arrays must have the same size");
        }
        float[] results = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            results[i] = metric.compare(a[i], b[i]);
        }
        return results;
    }

    public static StringMetric blockDistance() {
        return StringMetricBuilder.with(new BlockDistance<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric cosineSimilarity() {
        return StringMetricBuilder.with(new CosineSimilarity<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric diceSimilarity() {
        return StringMetricBuilder.with(new DiceSimilarity<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric euclideanDistance() {
        return StringMetricBuilder.with(new EuclideanDistance<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric jaccardSimilarity() {
        return StringMetricBuilder.with(new JaccardSimilarity<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric jaro() {
        return new Jaro();
    }

    public static StringMetric jaroWinkler() {
        return new JaroWinkler();
    }

    public static StringMetric levenshtein() {
        return new Levenshtein();
    }

    public static StringMetric matchingCoefficient() {
        return StringMetricBuilder.with(new MatchingCoefficient<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric mongeElkan() {
        return StringMetricBuilder.with(new MongeElkan(new SmithWatermanGotoh())).tokenize(new Whitespace()).build();
    }

    public static StringMetric needlemanWunch() {
        return new NeedlemanWunch();
    }

    public static StringMetric overlapCoefficient() {
        return StringMetricBuilder.with(new OverlapCoefficient<String>()).tokenize(new Whitespace()).build();
    }

    public static StringMetric qGramsDistance() {
        return StringMetricBuilder.with(new BlockDistance<String>()).tokenize(new QGramExtended(3)).build();
    }

    public static StringMetric simonWhite() {
        return StringMetricBuilder.with(new SimonWhite<String>()).tokenize(new Whitespace()).tokenize(new QGram(2)).build();
    }

    public static StringMetric smithWaterman() {
        return new SmithWaterman();
    }

    public static StringMetric smithWatermanGotoh() {
        return new SmithWatermanGotoh();
    }

    public static StringMetric soundex() {
        return StringMetricBuilder.with(new JaroWinkler()).simplify(new Soundex()).build();
    }
}

