/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import java.util.Objects;
import org.simmetrics.StringMetric;

public class Levenshtein
implements StringMetric {
    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        return 1.0f - Levenshtein.levenstein(a, b) / (float)Math.max(a.length(), b.length());
    }

    private static float levenstein(String s, String t) {
        int i;
        if (Objects.equals(s, t)) {
            return 0.0f;
        }
        if (s.isEmpty()) {
            return t.length();
        }
        if (t.isEmpty()) {
            return s.length();
        }
        float[] v0 = new float[t.length() + 1];
        float[] v1 = new float[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            int j;
            v1[0] = i + 1;
            for (j = 0; j < t.length(); ++j) {
                v1[j + 1] = org.simmetrics.utils.Math.min3(v1[j] + 1.0f, v0[j + 1] + 1.0f, v0[j] + (s.charAt(i) == t.charAt(j) ? 0.0f : 1.0f));
            }
            for (j = 0; j < v0.length; ++j) {
                v0[j] = v1[j];
            }
        }
        return v1[t.length()];
    }

    public String toString() {
        return "Levenshtein";
    }
}

