/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.metrics;

import com.google.common.base.Preconditions;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.functions.MatchMismatch;
import org.simmetrics.metrics.functions.Substitution;

public class SmithWatermanGotoh
implements StringMetric {
    private static final Substitution MATCH_1_MISMATCH_MINUS_2 = new MatchMismatch(1.0f, -2.0f);
    private final float gapValue;
    private Substitution substitution;

    public SmithWatermanGotoh() {
        this(-0.5f, MATCH_1_MISMATCH_MINUS_2);
    }

    public SmithWatermanGotoh(float gapValue, Substitution substitution) {
        Preconditions.checkArgument((gapValue <= 0.0f ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)substitution);
        this.gapValue = gapValue;
        this.substitution = substitution;
    }

    @Override
    public float compare(String a, String b) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return 0.0f;
        }
        float maxDistance = (float)Math.min(a.length(), b.length()) * Math.max(this.substitution.max(), this.gapValue);
        return this.smithWaterman(a, b) / maxDistance;
    }

    private float smithWaterman(String s, String t) {
        if (s.isEmpty()) {
            return t.length();
        }
        if (t.isEmpty()) {
            return s.length();
        }
        float[] v0 = new float[t.length()];
        float[] v1 = new float[t.length()];
        float max = v0[0] = org.simmetrics.utils.Math.max3(0.0f, this.gapValue, this.substitution.compare(s, 0, t, 0));
        for (int j = 1; j < v0.length; ++j) {
            v0[j] = org.simmetrics.utils.Math.max3(0.0f, v0[j - 1] + this.gapValue, this.substitution.compare(s, 0, t, j));
            max = Math.max(max, v0[j]);
        }
        for (int i = 1; i < s.length(); ++i) {
            int j;
            v1[0] = org.simmetrics.utils.Math.max3(0.0f, v0[0] + this.gapValue, this.substitution.compare(s, i, t, 0));
            max = Math.max(max, v1[0]);
            for (j = 1; j < v0.length; ++j) {
                v1[j] = org.simmetrics.utils.Math.max4(0.0f, v0[j] + this.gapValue, v1[j - 1] + this.gapValue, v0[j - 1] + this.substitution.compare(s, i, t, j));
                max = Math.max(max, v1[j]);
            }
            for (j = 0; j < v0.length; ++j) {
                v0[j] = v1[j];
            }
        }
        return max;
    }

    public String toString() {
        return "SmithWaterman [substitution=" + this.substitution + ", gapValue=" + this.gapValue + "]";
    }
}

