/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.simplifiers;

import java.text.Normalizer;
import java.util.regex.Pattern;
import org.simmetrics.simplifiers.Simplifier;

public class NonDiacritics
implements Simplifier {
    private static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    @Override
    public String simplify(String input) {
        return DIACRITICS_AND_FRIENDS.matcher(Normalizer.normalize(input, Normalizer.Form.NFD)).replaceAll("");
    }

    public String toString() {
        return "NonDiacritics";
    }
}

