/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.utils.SimplifyingSimplifier;

public class CachingSimplifier
implements SimplifyingSimplifier {
    private Simplifier simplifier;
    private final LoadingCache<String, String> cache;

    public CachingSimplifier(int initialCapacity, int maximumSize, Simplifier simplifier) {
        this(initialCapacity, maximumSize);
        this.simplifier = simplifier;
    }

    public CachingSimplifier(int initialCapacity, int maximumSize) {
        this.cache = CacheBuilder.newBuilder().initialCapacity(initialCapacity).maximumSize((long)maximumSize).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                Simplifier s = CachingSimplifier.this.getSimplifier();
                if (s == null) {
                    throw new NullPointerException("No simplifier was set");
                }
                return s.simplify(key);
            }
        });
    }

    @Override
    public Simplifier getSimplifier() {
        return this.simplifier;
    }

    @Override
    public void setSimplifier(Simplifier simplifier) {
        this.simplifier = simplifier;
    }

    @Override
    public String simplify(String input) {
        try {
            return (String)this.cache.get((Object)input);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "CachingSimplifier [" + this.simplifier + "]";
    }
}

