/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.utils;

import com.google.common.base.Preconditions;
import java.util.List;
import org.simmetrics.Metric;
import org.simmetrics.StringMetric;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.tokenizers.Tokenizer;

public final class CompositeListMetric
implements StringMetric {
    private final Metric<List<String>> metric;
    private final Simplifier simplifier;
    private final Tokenizer tokenizer;

    public CompositeListMetric(Metric<List<String>> metric, Simplifier simplifier, Tokenizer tokenizer) {
        Preconditions.checkNotNull(metric);
        Preconditions.checkNotNull((Object)simplifier);
        Preconditions.checkNotNull((Object)tokenizer);
        this.metric = metric;
        this.simplifier = simplifier;
        this.tokenizer = tokenizer;
    }

    @Override
    public float compare(String a, String b) {
        return this.metric.compare(this.tokenizer.tokenizeToList(this.simplifier.simplify(a)), this.tokenizer.tokenizeToList(this.simplifier.simplify(b)));
    }

    public String toString() {
        return this.metric + " [" + this.simplifier + " -> " + this.tokenizer + "]";
    }
}

