/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jdmf.algorithms.DataMiningAlgorithm;
import net.sf.jdmf.data.input.attribute.AttributeConverter;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.output.Item;
import net.sf.jdmf.data.output.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataMiningAlgorithm
implements DataMiningAlgorithm {
    private static Log log = LogFactory.getLog(AbstractDataMiningAlgorithm.class);
    protected AttributeConverter attributeConverter = new AttributeConverter();

    protected abstract String getName();

    protected Integer calculateCoverage(Rule rule, List<Instance> instances) {
        Integer coverage = 0;
        for (Instance currentInstance : instances) {
            if (!rule.evaluate(currentInstance)) continue;
            coverage = coverage + 1;
        }
        log.debug((Object)("coverage( " + rule + " ) = " + coverage));
        return coverage;
    }

    protected Double calculateAccuracy(Rule rule, List<Instance> instances) {
        Double accuracy = this.calculateCoverage(rule, instances).doubleValue();
        if (accuracy == 0.0) {
            return accuracy;
        }
        Rule conditionsOnly = new Rule();
        conditionsOnly.setConditions(rule.getConditions());
        accuracy = accuracy / (double)this.calculateCoverage(conditionsOnly, instances).intValue();
        log.debug((Object)("accuracy( " + rule + " ) = " + accuracy));
        return accuracy;
    }

    protected List<Instance> getInstancesCoveredByRule(Rule rule, List<Instance> instances) {
        ArrayList<Instance> instancesCovered = new ArrayList<Instance>();
        for (Instance currentInstance : instances) {
            if (!rule.evaluate(currentInstance)) continue;
            instancesCovered.add(currentInstance);
        }
        return instancesCovered;
    }

    protected Integer calculateCoverage(Set<Item> itemSet, List<Instance> instances) {
        Integer coverage = 0;
        for (Instance currentInstance : instances) {
            boolean isItemSetCovered = true;
            for (Item item : itemSet) {
                isItemSetCovered &= item.evaluate(currentInstance);
            }
            if (!isItemSetCovered) continue;
            coverage = coverage + 1;
        }
        log.debug((Object)("coverage( " + itemSet + " ) = " + coverage));
        return coverage;
    }
}

