/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jdmf.algorithms.AbstractDataMiningAlgorithm;
import net.sf.jdmf.data.input.InputData;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.attribute.AttributeType;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.input.attribute.probability.AttributeValueProbability;
import net.sf.jdmf.data.input.attribute.probability.AttributeValueProbabilityComparator;
import net.sf.jdmf.data.output.DataMiningModel;
import net.sf.jdmf.data.output.Rule;
import net.sf.jdmf.data.output.RuleElement;
import net.sf.jdmf.util.MathCalculator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BayesAlgorithm
extends AbstractDataMiningAlgorithm {
    private static Log log = LogFactory.getLog(BayesAlgorithm.class);
    protected MathCalculator mathCalculator = new MathCalculator();

    @Override
    public DataMiningModel analyze(InputData inputData) {
        DataMiningModel dataMiningModel = new DataMiningModel();
        List<Rule> rules = dataMiningModel.getRules();
        for (Attribute decision : inputData.getDecisions()) {
            Rule ruleBasedOnDecision = this.analyzeDecision(decision, inputData.getAttributes(), inputData.getInstanceToBeClassified());
            rules.add(ruleBasedOnDecision);
        }
        return dataMiningModel;
    }

    protected Rule analyzeDecision(Attribute decision, List<Attribute> attributes, Instance instanceToBeClassified) {
        List<AttributeValueProbability> decisionValueProbabilities = this.calculateDecisionValueProbabilities(decision, attributes, instanceToBeClassified);
        log.debug((Object)("decisionValueProbabilities: " + decisionValueProbabilities));
        Collections.sort(decisionValueProbabilities, new AttributeValueProbabilityComparator());
        AttributeValueProbability highestProbability = decisionValueProbabilities.get(decisionValueProbabilities.size() - 1);
        Rule ruleBasedOnDecision = new Rule();
        RuleElement currentRuleElement = null;
        for (String attributeName : instanceToBeClassified.getAttributeNames()) {
            if (currentRuleElement == null) {
                currentRuleElement = ruleBasedOnDecision.defineIf().attribute(attributeName).equals(instanceToBeClassified.getValue(attributeName));
                continue;
            }
            currentRuleElement = currentRuleElement.and(ruleBasedOnDecision).attribute(attributeName).equals(instanceToBeClassified.getValue(attributeName));
        }
        ruleBasedOnDecision.defineThen().attribute(decision.getName()).equals(highestProbability.getAttributeValue());
        return ruleBasedOnDecision;
    }

    protected List<AttributeValueProbability> calculateDecisionValueProbabilities(Attribute decision, List<Attribute> attributes, Instance instanceToBeClassified) {
        ArrayList<Attribute> attributesWithDecision = new ArrayList<Attribute>(attributes);
        attributesWithDecision.add(decision);
        HashSet<String> attributeNames = new HashSet<String>(instanceToBeClassified.getAttributeNames());
        attributeNames.add(decision.getName());
        List<Attribute> filteredAttributes = this.filterSelectedAttributes(attributesWithDecision, attributeNames);
        List<Instance> instances = this.attributeConverter.convertToInstances(filteredAttributes);
        filteredAttributes.remove(decision);
        Map<Comparable, Integer> decisionValuesCount = decision.getValuesCount();
        ArrayList<AttributeValueProbability> probabilities = new ArrayList<AttributeValueProbability>();
        Double likelihoodSum = 0.0;
        for (Comparable decisionValue : decision.getDistinctValues()) {
            Double decisionValueLikelihood = 1.0;
            for (Attribute filteredAttribute : filteredAttributes) {
                Double attributeValueLikelihood = this.calculateAttributeValueLikelihood(filteredAttribute, decision.getName(), decisionValue, decisionValuesCount.get(decisionValue), instanceToBeClassified, instances);
                decisionValueLikelihood = decisionValueLikelihood * attributeValueLikelihood;
            }
            log.debug((Object)("count( " + decisionValue + " ) = " + decisionValuesCount.get(decisionValue)));
            log.debug((Object)("valuesCount = " + instances.size()));
            decisionValueLikelihood = decisionValueLikelihood * (double)decisionValuesCount.get(decisionValue).intValue();
            decisionValueLikelihood = decisionValueLikelihood / (double)instances.size();
            log.debug((Object)("likelihood( " + decisionValue + " ) = " + decisionValueLikelihood));
            AttributeValueProbability probability = new AttributeValueProbability(decisionValue, decisionValueLikelihood);
            probabilities.add(probability);
            likelihoodSum = likelihoodSum + decisionValueLikelihood;
        }
        for (AttributeValueProbability probability : probabilities) {
            probability.setProbability(probability.getProbability() / likelihoodSum);
        }
        return probabilities;
    }

    protected Double calculateAttributeValueLikelihood(Attribute attribute, String decisionName, Comparable decisionValue, Integer decisionValueCount, Instance instanceToBeClassified, List<Instance> instances) {
        if (attribute.getType().equals((Object)AttributeType.NUMERIC)) {
            List<Comparable> selectedValues = this.attributeConverter.groupFirstAttributeValuesBySecondAttributeValue(attribute.getName(), decisionName, decisionValue, instances);
            return this.mathCalculator.calculateNormalDistribution(selectedValues.toArray(new Comparable[selectedValues.size()]), (Double)instanceToBeClassified.getValue(attribute.getName()));
        }
        String attributeName = attribute.getName();
        Rule rule = this.generateRule(attributeName, instanceToBeClassified.getValue(attributeName), decisionName, decisionValue);
        Integer ruleCoverage = this.calculateCoverage(rule, instances);
        return ruleCoverage.doubleValue() / (double)decisionValueCount.intValue();
    }

    protected List<Attribute> filterSelectedAttributes(List<Attribute> attributes, Set<String> attributeNames) {
        ArrayList<Attribute> selectedAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            if (!attributeNames.contains(attribute.getName())) continue;
            selectedAttributes.add(attribute);
        }
        return selectedAttributes;
    }

    protected Rule generateRule(String attributeName, Comparable attributeValue, String decisionName, Comparable decisionValue) {
        Rule rule = new Rule();
        rule.defineIf().attribute(attributeName).equals(attributeValue);
        rule.defineThen().attribute(decisionName).equals(decisionValue);
        return rule;
    }

    @Override
    protected String getName() {
        return "Bayes Algorithm";
    }
}

