/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.algorithms.classification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jdmf.algorithms.AbstractDataMiningAlgorithm;
import net.sf.jdmf.data.input.InputData;
import net.sf.jdmf.data.input.attribute.Attribute;
import net.sf.jdmf.data.input.attribute.Instance;
import net.sf.jdmf.data.output.DataMiningModel;
import net.sf.jdmf.data.output.Rule;
import net.sf.jdmf.data.output.RuleElement;
import net.sf.jdmf.data.output.RuleInfo;

public class PRISMAlgorithm
extends AbstractDataMiningAlgorithm {
    @Override
    public DataMiningModel analyze(InputData inputData) {
        DataMiningModel dataMiningModel = new DataMiningModel();
        List<Rule> rules = dataMiningModel.getRules();
        for (Attribute decision : inputData.getDecisions()) {
            List<Rule> singleDecisionRules = this.analyzeDecision(decision, inputData.getAttributes());
            rules.addAll(singleDecisionRules);
        }
        return dataMiningModel;
    }

    protected List<Rule> analyzeDecision(Attribute decision, List<Attribute> attributes) {
        ArrayList<Rule> singleDecisionRules = new ArrayList<Rule>();
        for (Comparable decisionValue : decision.getDistinctValues()) {
            List<Rule> rulesBasedOnDecisionValue = this.buildRulesBasedOnDecisionValue(attributes, decision, decisionValue);
            singleDecisionRules.addAll(rulesBasedOnDecisionValue);
        }
        return singleDecisionRules;
    }

    protected List<Rule> buildRulesBasedOnDecisionValue(List<Attribute> attributes, Attribute decision, Comparable decisionValue) {
        ArrayList<Attribute> attributesWithDecision = new ArrayList<Attribute>(attributes);
        attributesWithDecision.add(decision);
        List<Instance> instances = this.attributeConverter.convertToInstances(attributesWithDecision);
        ArrayList<Attribute> remainingAttributes = new ArrayList<Attribute>(attributes);
        ArrayList<Rule> rulesBasedOnDecision = new ArrayList<Rule>();
        Rule currentRule = new Rule();
        currentRule.defineThen().attribute(decision.getName()).equals(decisionValue);
        Double currentRuleAccuracy = this.calculateAccuracy(currentRule, instances);
        while (currentRuleAccuracy != 0.0) {
            if (currentRuleAccuracy == 1.0) {
                rulesBasedOnDecision.add(currentRule);
                List<Instance> instancesCoveredByCurrentRule = this.getInstancesCoveredByRule(currentRule, instances);
                instances.removeAll(instancesCoveredByCurrentRule);
                currentRule = new Rule();
                currentRule.defineThen().attribute(decision.getName()).equals(decisionValue);
                remainingAttributes = new ArrayList<Attribute>(attributes);
            } else {
                if (remainingAttributes.isEmpty()) break;
                ArrayList<RuleInfo> ruleInfos = new ArrayList<RuleInfo>();
                for (Attribute attribute : remainingAttributes) {
                    for (Comparable attributeValue : attribute.getDistinctValues()) {
                        Rule extendedRule = this.extendRule(currentRule, attribute.getName(), attributeValue);
                        RuleInfo ruleInfo = this.generateRuleInfo(extendedRule, instances);
                        ruleInfos.add(ruleInfo);
                    }
                }
                Collections.sort(ruleInfos);
                RuleInfo bestRuleInfo = (RuleInfo)ruleInfos.get(ruleInfos.size() - 1);
                currentRule = bestRuleInfo.getRule();
                RuleElement currentRuleLastCondition = currentRule.getLastCondition();
                String usedAttributeName = currentRuleLastCondition.getItem().getAttributeName();
                Iterator remainingAttributesIterator = remainingAttributes.iterator();
                while (remainingAttributesIterator.hasNext()) {
                    Attribute attribute = (Attribute)remainingAttributesIterator.next();
                    if (!attribute.getName().equals(usedAttributeName)) continue;
                    remainingAttributesIterator.remove();
                    break;
                }
            }
            currentRuleAccuracy = this.calculateAccuracy(currentRule, instances);
        }
        return rulesBasedOnDecision;
    }

    protected RuleInfo generateRuleInfo(Rule rule, List<Instance> instances) {
        Integer ruleCoverage = this.calculateCoverage(rule, instances);
        Double ruleAccuracy = this.calculateAccuracy(rule, instances);
        RuleInfo ruleInfo = new RuleInfo(rule, ruleCoverage, ruleAccuracy);
        return ruleInfo;
    }

    protected Rule extendRule(Rule rule, String attributeName, Comparable attributeValue) {
        Rule extendedRule = new Rule();
        extendedRule.setConditions(new ArrayList<RuleElement>(rule.getConditions()));
        extendedRule.setConsequences(new ArrayList<RuleElement>(rule.getConsequences()));
        if (extendedRule.getConditions().isEmpty()) {
            extendedRule.defineIf().attribute(attributeName).equals(attributeValue);
        } else {
            RuleElement lastCondition = rule.getLastCondition();
            lastCondition.and(extendedRule).attribute(attributeName).equals(attributeValue);
        }
        return extendedRule;
    }

    @Override
    protected String getName() {
        return "PRISM Algorithm";
    }
}

