/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jdmf.visualization.clustering;

import java.util.List;
import java.util.Vector;
import net.sf.jdmf.data.output.clustering.Cluster;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartGenerator {
    public JFreeChart generateXYChart(List<Cluster> clusters, Integer firstAttributeIndex, String firstAttributeName, Integer secondAttributeIndex, String secondAttributeName) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Cluster cluster : clusters) {
            XYSeries series = new XYSeries((Comparable)((Object)cluster.getName()));
            for (Vector<Double> point : cluster.getPoints()) {
                series.add((Number)point.get(firstAttributeIndex), (Number)point.get(secondAttributeIndex));
            }
            dataset.addSeries(series);
        }
        return ChartFactory.createScatterPlot((String)"Cluster Analysis", (String)firstAttributeName, (String)secondAttributeName, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
    }

    public JFreeChart generatePieChart(List<Cluster> clusters) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Cluster cluster : clusters) {
            dataset.setValue((Comparable)((Object)cluster.getName()), (Number)cluster.getPointPercentage());
        }
        return ChartFactory.createPieChart3D((String)"Cluster Analysis", (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
    }
}

