/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.ArrayList;

final class Utils {
    private Utils() {
    }

    static double[] GaussElimination(double[][] a) {
        int n = a.length;
        return Utils.GaussElimination(n, a);
    }

    static double[] GaussElimination(int n, double[][] a) {
        int j;
        for (int k = 0; k < n - 1; ++k) {
            for (int i = k + 1; i < n; ++i) {
                double qt = a[i][k] / a[k][k];
                for (j = k + 1; j < n + 1; ++j) {
                    double[] dArray = a[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - qt * a[k][j];
                }
                a[i][k] = 0.0;
            }
        }
        double[] x = new double[n];
        x[n - 1] = a[n - 1][n] / a[n - 1][n - 1];
        for (int k = n - 2; k >= 0; --k) {
            double sum = 0.0;
            for (j = k + 1; j < n; ++j) {
                sum += a[k][j] * x[j];
            }
            x[k] = (a[k][n] - sum) / a[k][k];
        }
        return x;
    }

    static double[] calculateSeasonalIndices(double[] observation, int seasonalCycle) {
        int season;
        int numberOfCycles = observation.length / seasonalCycle;
        if (numberOfCycles < 2) {
            throw new IllegalArgumentException("Too few observations. Need at least " + seasonalCycle * 2 + " observations - preferably more - to calculate the seasonal indices");
        }
        if (seasonalCycle % 2 != 0) {
            throw new IllegalArgumentException("seasonalCycle must be even - for now at least");
        }
        if (observation.length % seasonalCycle > 0) {
            ++numberOfCycles;
        }
        double[] seasonalIndex = new double[seasonalCycle];
        ArrayList<Double> ratioToMovingAverage = new ArrayList<Double>(observation.length);
        double movingTotal = 0.0;
        for (int t = 0; t < seasonalCycle; ++t) {
            movingTotal += observation[t];
            ratioToMovingAverage.add(t, null);
        }
        int numberOfObservations = observation.length;
        for (int t = seasonalCycle; t < numberOfObservations; ++t) {
            double movingAverage = movingTotal / (double)(seasonalCycle * 2);
            movingTotal -= observation[t - seasonalCycle];
            int period = t - (seasonalCycle + 1) / 2;
            ratioToMovingAverage.add(period, new Double(observation[period] / (movingAverage += (movingTotal += observation[t]) / (double)(seasonalCycle * 2))));
        }
        boolean dropOutliers = numberOfCycles > 4;
        double sumIndices = 0.0;
        for (season = 0; season < seasonalCycle; ++season) {
            int count = 0;
            double sum = 0.0;
            double minIndex = Double.POSITIVE_INFINITY;
            double maxIndex = Double.NEGATIVE_INFINITY;
            for (int cycle = 0; cycle < numberOfCycles; ++cycle) {
                int t = season + cycle * seasonalCycle;
                if (ratioToMovingAverage.get(t) == null) continue;
                double currentIndex = (Double)ratioToMovingAverage.get(t);
                if (dropOutliers) {
                    if (currentIndex < minIndex) {
                        minIndex = currentIndex;
                    }
                    if (currentIndex > maxIndex) {
                        maxIndex = currentIndex;
                    }
                }
                sum += currentIndex;
                ++count;
            }
            if (dropOutliers) {
                sum -= minIndex;
                --count;
                sum -= maxIndex;
                --count;
            }
            seasonalIndex[season] = sum / (double)count;
            sumIndices += seasonalIndex[season];
        }
        season = 0;
        while (season < seasonalCycle) {
            int n = season++;
            seasonalIndex[n] = seasonalIndex[n] * ((double)seasonalCycle / sumIndices);
        }
        return seasonalIndex;
    }
}

