/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.analytics;

import java.util.ArrayList;
import java.util.List;

public class LocationAnalysis {
    public static void main(String ... args) {
    }

    public static class LocationComparator {
        public double compare(double cLat, double cLong, double cradius, Object[] record, int latIndex, int longIndex) {
            double rLat = Math.toRadians(Double.parseDouble(record[latIndex].toString()));
            double rLong = Math.toRadians(Double.parseDouble(record[longIndex].toString()));
            double centerLat = Math.toRadians(cLat);
            double centerLong = Math.toRadians(cLong);
            double distance = 12742.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(Math.abs(rLat - centerLat) / 2.0), 2.0) + Math.cos(rLat) * Math.cos(centerLat) * Math.pow(Math.sin(Math.abs(rLong - centerLong) / 2.0), 2.0)));
            return distance - cradius;
        }
    }

    public class LocationGroup {
        private double centerLatitude;
        private double centerLongitude;
        private double radius;
        private List<List<String>> resultGroup;

        LocationGroup(double cLat, double cLong, double cradius) {
            this.centerLatitude = cLat;
            this.centerLongitude = cLong;
            this.radius = cradius;
            this.resultGroup = new ArrayList<List<String>>();
        }

        public double getCenterLatitude() {
            return this.centerLatitude;
        }

        public void setCenterLatitude(double centerLatitude) {
            this.centerLatitude = centerLatitude;
        }

        public double getCenterLongitude() {
            return this.centerLongitude;
        }

        public void setCenterLongitude(double centerLongitude) {
            this.centerLongitude = centerLongitude;
        }

        public double getRadius() {
            return this.radius;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }

        public List<List<String>> getResultGroup() {
            return this.resultGroup;
        }

        public void addResultGroupMember(List<String> resultGroup) {
            this.resultGroup.add(resultGroup);
        }
    }
}

