/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.datagen;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import org.arrah.framework.datagen.AggrCumRTM;
import org.arrah.framework.ndtable.ReportTableModel;

public class ExpressionBuilder {
    private static final String START_TOKEN = "#{";
    private static final String END_TOKEN = "}";

    public static String preparseJeval(String expression, ReportTableModel rpt, int selIndex, int beginIndex, int endIndex) {
        String jevalString = null;
        int startI = 0;
        int endI = 0;
        Hashtable<String, Integer> colTable = new Hashtable<String, Integer>();
        Hashtable<String, Vector<Double>> aggrColVal = new Hashtable<String, Vector<Double>>();
        boolean isNumber = false;
        boolean isCondition = false;
        String condition = null;
        String thenexpression = null;
        Evaluator eva = new Evaluator('\"', true, true, true, true);
        while ((startI = expression.indexOf(START_TOKEN, endI)) != -1 && (endI = expression.indexOf(END_TOKEN, startI)) != -1) {
            int j;
            String colName = expression.substring(startI + START_TOKEN.length(), endI);
            int i = ReportTableModel.getColumnIndex(rpt, colName);
            if (i < 0 && (j = ExpressionBuilder.findColumn(rpt, colName, aggrColVal)) < 0) {
                System.out.println("\n ERROR:Column Name Not Found in Table:" + colName);
                return null;
            }
            colTable.put(colName, i);
            try {
                if (i >= 0) {
                    Object obj = rpt.getModel().getValueAt(0, i);
                    if (obj == null) {
                        eva.putVariable(colName, "");
                        continue;
                    }
                    eva.putVariable(colName, obj.toString());
                    continue;
                }
                Vector<Double> val = aggrColVal.get(colName);
                if (val == null) continue;
                eva.putVariable(colName, val.get(0).toString());
            }
            catch (Exception e) {
                System.out.println("\n Exception :" + e);
                return null;
            }
        }
        try {
            expression = expression.trim();
            if (expression.startsWith("IF")) {
                int thenIndex = expression.indexOf(" THEN ", 2);
                if (thenIndex < 0) {
                    System.out.println("Format error  IF (condition) THEN expression");
                    return null;
                }
                condition = expression.substring(2, thenIndex);
                thenexpression = expression.substring(thenIndex + " THEN ".length());
                eva.parse(condition);
                String condOutput = eva.evaluate(false, false);
                isCondition = true;
                if (!condOutput.startsWith("0")) {
                    eva.parse(thenexpression);
                    jevalString = eva.evaluate(false, false);
                } else {
                    jevalString = "IF condition not met";
                }
            } else {
                eva.parse(expression);
                jevalString = eva.evaluate(false, false);
            }
            if (selIndex < 0) {
                return jevalString;
            }
        }
        catch (EvaluationException ee) {
            System.out.println("\n WARNING: Parsing Falied " + ee.getMessage());
            return jevalString;
        }
        if (rpt.getModel().getColumnClass(selIndex).getName().toUpperCase().contains("DOUBLE")) {
            isNumber = true;
        }
        Hashtable<String, String> varT = new Hashtable<String, String>();
        for (int i = beginIndex - 1; i < endIndex - 1; ++i) {
            Enumeration table_enum = colTable.keys();
            while (table_enum.hasMoreElements()) {
                String colKey = (String)table_enum.nextElement();
                int j = (Integer)colTable.get(colKey);
                if (j >= 0) {
                    Object obj = rpt.getModel().getValueAt(i, j);
                    if (obj == null) {
                        if (obj instanceof Number) {
                            varT.put(colKey, "0");
                            continue;
                        }
                        varT.put(colKey, "");
                        continue;
                    }
                    varT.put(colKey, obj.toString());
                    continue;
                }
                Vector<Double> val = aggrColVal.get(colKey);
                if (val == null) {
                    varT.put(colKey, "0");
                    continue;
                }
                if (val.size() == 1) {
                    varT.put(colKey, val.get(0).toString());
                    continue;
                }
                varT.put(colKey, val.get(i).toString());
            }
            eva.setVariables(varT);
            try {
                if (isCondition) {
                    eva.parse(condition);
                    String condOutput = eva.evaluate(false, false);
                    if (condOutput.startsWith("0")) continue;
                    eva.parse(thenexpression);
                    jevalString = eva.evaluate(false, false);
                } else {
                    jevalString = eva.evaluate(false, false);
                }
            }
            catch (EvaluationException ee) {
                System.out.println("\n Parse WARNING:  Row id: " + (i + 1) + " :" + ee.getMessage());
                rpt.getModel().setValueAt(null, i, selIndex);
                continue;
            }
            if (isNumber) {
                try {
                    rpt.getModel().setValueAt(Double.parseDouble(jevalString), i, selIndex);
                }
                catch (NumberFormatException exp) {
                    System.out.println("\n Format WARNING:  Row id: " + (i + 1) + " :" + exp.getMessage());
                    rpt.getModel().setValueAt(null, i, selIndex);
                }
                continue;
            }
            rpt.getModel().setValueAt(jevalString, i, selIndex);
        }
        return jevalString;
    }

    private static int findColumn(ReportTableModel rpt, String colName, Hashtable<String, Vector<Double>> aggrColVal) {
        if (colName == null || "".equals(colName)) {
            return -1;
        }
        Vector<Double> colData = new Vector();
        if (colName.startsWith("SUM_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("SUM_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Double sum = AggrCumRTM.getSum(colData);
            Vector<Double> sum_v = new Vector<Double>();
            sum_v.add(sum);
            aggrColVal.put(colName, sum_v);
            return 1;
        }
        if (colName.startsWith("AVG_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("AVG_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Double avg = AggrCumRTM.getAverage(colData);
            Vector<Double> avg_v = new Vector<Double>();
            avg_v.add(avg);
            aggrColVal.put(colName, avg_v);
            return 2;
        }
        if (colName.startsWith("MIN_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("MIN_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            double[] minmax = AggrCumRTM.getMinMax(colData);
            Vector<Double> min_v = new Vector<Double>();
            min_v.add(minmax[0]);
            aggrColVal.put(colName, min_v);
            return 3;
        }
        if (colName.startsWith("MAX_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("MAX_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            double[] minmax = AggrCumRTM.getMinMax(colData);
            Vector<Double> max_v = new Vector<Double>();
            max_v.add(minmax[1]);
            aggrColVal.put(colName, max_v);
            return 4;
        }
        if (colName.startsWith("CUMSUM_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("CUMSUM_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Vector<Double> cumsum = AggrCumRTM.getCumSum(colData);
            aggrColVal.put(colName, cumsum);
            return 6;
        }
        if (colName.startsWith("CUMAVG_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("CUMAVG_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Vector<Double> cumavg = AggrCumRTM.getCumAvg(colData);
            aggrColVal.put(colName, cumavg);
            return 7;
        }
        if (colName.startsWith("PREV_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("PREV_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Vector<Double> prevavg = AggrCumRTM.putPrevVal(colData);
            aggrColVal.put(colName, prevavg);
            return 8;
        }
        if (colName.startsWith("NEXT_")) {
            int i = ReportTableModel.getColumnIndex(rpt, colName.substring("NEXT_".length()));
            if (i < 0) {
                return i;
            }
            colData = AggrCumRTM.getColumnNumberData(rpt, i);
            Vector<Double> nextavg = AggrCumRTM.putNextVal(colData);
            aggrColVal.put(colName, nextavg);
            return 9;
        }
        return -1;
    }
}

