/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.dataquality;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.arrah.framework.dataquality.FormatCheck;
import org.arrah.framework.dataquality.SimilarityCheckLucene;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.JDBCRowset;
import org.arrah.framework.rdbms.Rdbms_conn;
import org.arrah.framework.rdbms.SqlType;
import org.arrah.framework.util.StringCaseFormatUtil;

public class QualityCheck {
    private int matchI = -1;
    private Vector<Integer> mrowI;

    public ReportTableModel searchReplace(JDBCRowset rows, String col, Hashtable<String, String> filter, String options) throws SQLException {
        String[] col_name = rows.getColName();
        String[] colType = rows.getColType();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        Object replace = null;
        String metaType = SqlType.getMetaTypeName(colType[this.matchI]);
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int rowC = rows.getRowCount();
        int mrowC = 0;
        Enumeration<String> en = filter.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            Pattern p = null;
            try {
                p = options.charAt(0) == '0' && options.charAt(2) == '1' ? Pattern.compile(key, 18) : (options.charAt(0) == '1' && options.charAt(2) == '1' ? Pattern.compile(key, 16) : (options.charAt(0) == '0' && options.charAt(2) == '0' ? Pattern.compile(key, 2) : Pattern.compile(key)));
            }
            catch (PatternSyntaxException pe) {
                System.out.println("Pattern Compile Exception:" + pe.getMessage());
                continue;
            }
            catch (IllegalArgumentException ee) {
                System.out.println("Illegal Argument Exception:" + ee.getMessage());
                continue;
            }
            if (p == null) {
                System.out.println("Pattern is NULL");
                continue;
            }
            for (int i = 0; i < rowC; ++i) {
                Object obj = null;
                Object[] objA = null;
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0 ? (obj = (objA = rows.getRow(i + 1))[this.matchI]) == null : (obj = rows.getObject(i + 1, this.matchI + 1)) == null) continue;
                String value = obj.toString().trim().replaceAll("\\s+", " ");
                String[] valueTok = new String[]{value};
                if (options.charAt(1) == '0') {
                    valueTok = value.split(" ");
                }
                boolean matchFound = false;
                for (int j = 0; j < valueTok.length; ++j) {
                    try {
                        String newvalue;
                        Matcher m = p.matcher(valueTok[j]);
                        if (options.charAt(3) == '1') {
                            if (!m.matches()) continue;
                            valueTok[j] = newvalue = filter.get(key);
                            matchFound = true;
                            continue;
                        }
                        if (!m.find()) continue;
                        newvalue = filter.get(key);
                        valueTok[j] = newvalue = m.replaceAll(newvalue);
                        matchFound = true;
                        continue;
                    }
                    catch (PatternSyntaxException pe) {
                        System.out.println("\n Pattern Compile Exception:" + pe.getMessage());
                        break;
                    }
                }
                if (!matchFound) continue;
                try {
                    String newValue = "";
                    for (int j = 0; j < valueTok.length; ++j) {
                        if (!newValue.equals("")) {
                            newValue = newValue + " ";
                        }
                        newValue = newValue + valueTok[j];
                    }
                    try {
                        replace = metaType.toUpperCase().contains("NUMBER") ? Double.valueOf(Double.parseDouble(newValue)) : (metaType.toUpperCase().contains("DATE") ? new SimpleDateFormat("dd-MM-yyyy").parse(newValue) : new String(newValue));
                    }
                    catch (Exception exp) {
                        System.out.println("\n WANING: Could not Parse Input String:" + newValue);
                    }
                    if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                        objA = rows.getRow(i + 1);
                    }
                    Object[] add_obj = new Object[objA.length + 1];
                    add_obj[0] = replace;
                    for (int k = 0; k < objA.length; ++k) {
                        add_obj[k + 1] = objA[k];
                    }
                    rt.addFillRow(add_obj);
                    this.mrowI.add(mrowC++, i + 1);
                    continue;
                }
                catch (SQLException se) {
                    System.out.println("\n Exception :" + se.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("\n Exception :" + ex.getMessage());
                }
            }
        }
        return rt;
    }

    public ReportTableModel nullReplace(JDBCRowset rows, String col, String replaceWith) throws SQLException {
        String[] col_name = rows.getColName();
        String[] colType = rows.getColType();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        Object replace = null;
        String metaType = SqlType.getMetaTypeName(colType[this.matchI]);
        try {
            replace = metaType.toUpperCase().contains("NUMBER") ? Double.valueOf(Double.parseDouble(replaceWith)) : (metaType.toUpperCase().contains("DATE") ? new SimpleDateFormat("dd-MM-yyyy").parse(replaceWith) : new String(replaceWith));
        }
        catch (Exception exp) {
            System.out.println("\n WANING: Could not Parse Input String:" + replaceWith);
        }
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int rowC = rows.getRowCount();
        int mrowC = 0;
        for (int i = 0; i < rowC; ++i) {
            Object obj = null;
            Object[] objA = null;
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0) {
                objA = rows.getRow(i + 1);
                obj = objA[this.matchI];
            } else {
                obj = rows.getObject(i + 1, this.matchI + 1);
            }
            if (obj != null && !"".equals(obj.toString())) continue;
            try {
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    objA = rows.getRow(i + 1);
                }
                Object[] add_obj = new Object[objA.length + 1];
                add_obj[0] = replace;
                for (int k = 0; k < objA.length; ++k) {
                    add_obj[k + 1] = objA[k];
                }
                rt.addFillRow(add_obj);
                this.mrowI.add(mrowC++, i + 1);
                continue;
            }
            catch (SQLException se) {
                System.out.println("\n Exception :" + se.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("\n Exception :" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return rt;
    }

    public ReportTableModel patternMatch(JDBCRowset rows, String col, String type, Object[] pattern, boolean isMatch) throws SQLException {
        String[] col_name = rows.getColName();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int rowC = rows.getRowCount();
        int mrowC = 0;
        for (int i = 0; i < rowC; ++i) {
            Object d;
            Object obj = null;
            Object[] objA = null;
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0 ? (obj = (objA = rows.getRow(i + 1))[this.matchI]) == null : (obj = rows.getObject(i + 1, this.matchI + 1)) == null) continue;
            boolean isObjMatch = false;
            if (type.equals("Number")) {
                d = FormatCheck.parseNumber(obj.toString(), pattern);
                if (d != null && isMatch) {
                    isObjMatch = true;
                }
                if (d == null && !isMatch) {
                    isObjMatch = true;
                }
            } else if (type.equals("Date")) {
                d = FormatCheck.parseDate(obj.toString(), pattern);
                if (d != null && isMatch) {
                    isObjMatch = true;
                }
                if (d == null && !isMatch) {
                    isObjMatch = true;
                }
            } else {
                d = FormatCheck.parseString(obj.toString(), pattern);
                if (d != null && isMatch) {
                    isObjMatch = true;
                }
                if (d == null && !isMatch) {
                    isObjMatch = true;
                }
            }
            if (!isObjMatch) continue;
            try {
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    objA = rows.getRow(i + 1);
                }
                Object[] add_obj = new Object[objA.length + 1];
                add_obj[0] = obj;
                for (int k = 0; k < objA.length; ++k) {
                    add_obj[k + 1] = objA[k];
                }
                rt.addFillRow(add_obj);
                this.mrowI.add(mrowC++, i + 1);
                continue;
            }
            catch (SQLException se) {
                System.out.println("\n Exception :" + se.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("\n Exception :" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return rt;
    }

    public ReportTableModel caseFormat(JDBCRowset rows, String col, int formatType, char defChar) throws SQLException {
        String[] col_name = rows.getColName();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int rowC = rows.getRowCount();
        int mrowC = 0;
        for (int i = 0; i < rowC; ++i) {
            Object obj = null;
            Object[] objA = null;
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0 ? (obj = (objA = rows.getRow(i + 1))[this.matchI]) == null : (obj = rows.getObject(i + 1, this.matchI + 1)) == null) continue;
            String searchFormat = obj.toString();
            String valueFormat = null;
            boolean isObjMatch = true;
            switch (formatType) {
                case 1: {
                    if (StringCaseFormatUtil.isUpperCase(searchFormat)) break;
                    valueFormat = StringCaseFormatUtil.toUpperCase(searchFormat);
                    isObjMatch = false;
                    break;
                }
                case 2: {
                    if (StringCaseFormatUtil.isLowerCase(searchFormat)) break;
                    valueFormat = StringCaseFormatUtil.toLowerCase(searchFormat);
                    isObjMatch = false;
                    break;
                }
                case 3: {
                    if (StringCaseFormatUtil.isTitleCase(searchFormat)) break;
                    valueFormat = StringCaseFormatUtil.toTitleCase(searchFormat);
                    isObjMatch = false;
                    break;
                }
                case 4: {
                    if (StringCaseFormatUtil.isSentenceCase(searchFormat, defChar)) break;
                    valueFormat = StringCaseFormatUtil.toSentenceCase(searchFormat, defChar);
                    isObjMatch = false;
                    break;
                }
            }
            if (isObjMatch) continue;
            try {
                String value = valueFormat;
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    objA = rows.getRow(i + 1);
                }
                Object[] add_obj = new Object[objA.length + 1];
                add_obj[0] = value;
                for (int k = 0; k < objA.length; ++k) {
                    add_obj[k + 1] = objA[k];
                }
                rt.addFillRow(add_obj);
                this.mrowI.add(mrowC++, i + 1);
                continue;
            }
            catch (SQLException se) {
                System.out.println("\n Exception :" + se.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("\n Exception :" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return rt;
    }

    public ReportTableModel discreetSearch(JDBCRowset rows, String col, Vector<String> token, boolean match) throws SQLException {
        String[] col_name = rows.getColName();
        String[] colType = rows.getColType();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        Object replace = null;
        String metaType = SqlType.getMetaTypeName(colType[this.matchI]);
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int rowC = rows.getRowCount();
        int mrowC = 0;
        for (int i = 0; i < rowC; ++i) {
            Object obj = null;
            Object[] objA = null;
            if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") == 0 ? (obj = (objA = rows.getRow(i + 1))[this.matchI]) == null : (obj = rows.getObject(i + 1, this.matchI + 1)) == null) continue;
            String value = obj.toString();
            int tokenI = 0;
            boolean matchFound = false;
            while (tokenI < token.size()) {
                String key = token.elementAt(tokenI++);
                try {
                    if (!Pattern.matches(key, value)) continue;
                    matchFound = true;
                    break;
                }
                catch (PatternSyntaxException pe) {
                    System.out.println("\n Pattern Compile Exception:" + pe.getMessage());
                }
            }
            if (matchFound != match) continue;
            try {
                String newValue = value;
                try {
                    replace = metaType.toUpperCase().contains("NUMBER") ? Double.valueOf(Double.parseDouble(newValue)) : (metaType.toUpperCase().contains("DATE") ? new SimpleDateFormat("dd-MM-yyyy").parse(newValue) : new String(newValue));
                }
                catch (Exception exp) {
                    System.out.println("\n WANING: Could not Parse Input String:" + newValue);
                }
                if (Rdbms_conn.getHValue("Database_Type").compareToIgnoreCase("hive") != 0) {
                    objA = rows.getRow(i + 1);
                }
                Object[] add_obj = new Object[objA.length + 1];
                add_obj[0] = replace;
                for (int k = 0; k < objA.length; ++k) {
                    add_obj[k + 1] = objA[k];
                }
                rt.addFillRow(add_obj);
                this.mrowI.add(mrowC++, i + 1);
                continue;
            }
            catch (SQLException se) {
                System.out.println("\n Exception :" + se.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("\n Exception :" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return rt;
    }

    public void setrowIndex(Vector<Integer> mrowI) {
        this.mrowI = mrowI;
    }

    public Vector<Integer> getrowIndex() {
        return this.mrowI;
    }

    public int getColMatchIndex() {
        return this.matchI;
    }

    public ReportTableModel searchReplaceFuzzy(JDBCRowset rows, String col, Hashtable<String, String> filter) throws SQLException {
        String[] col_name = rows.getColName();
        String[] colType = rows.getColType();
        String[] add_col = new String[col_name.length + 1];
        for (int j = 0; j < col_name.length; ++j) {
            if (!col.equals(col_name[j])) continue;
            this.matchI = j;
            break;
        }
        if (this.matchI < 0) {
            System.out.println("Selected Column is Not matching Database Columns");
            return null;
        }
        Object replace = null;
        String metaType = SqlType.getMetaTypeName(colType[this.matchI]);
        add_col[0] = col_name[this.matchI] + " Editable";
        for (int i = 0; i < col_name.length; ++i) {
            add_col[i + 1] = col_name[i];
        }
        ReportTableModel rt = new ReportTableModel(add_col);
        this.mrowI = new Vector();
        int mrowC = 0;
        SimilarityCheckLucene _simcheck = new SimilarityCheckLucene(rows);
        _simcheck.makeIndex();
        Enumeration<String> en = filter.keys();
        block6: while (en.hasMoreElements()) {
            Vector<Integer> matchedIndex;
            String key = en.nextElement().toString();
            if (key == null || "".equals(key)) {
                System.out.println("Key is NULL");
                continue;
            }
            String fuzzyquery = _simcheck.prepareLQuery(key, col);
            Object[][] matchedrow = _simcheck.searchTableObject(fuzzyquery);
            if (matchedrow == null || (matchedIndex = _simcheck.getMatchedRowIndex()) == null || matchedIndex.size() == 0) continue;
            for (int i = 0; i < matchedrow.length; ++i) {
                try {
                    int matchedIndexVal = matchedIndex.get(i);
                    if (this.mrowI.indexOf(matchedIndexVal) != -1) continue;
                    String newValue = filter.get(key);
                    if (newValue == null) continue block6;
                    try {
                        replace = metaType.toUpperCase().contains("NUMBER") ? Double.valueOf(Double.parseDouble(newValue)) : (metaType.toUpperCase().contains("DATE") ? new SimpleDateFormat("dd-MM-yyyy").parse(newValue) : new String(newValue));
                    }
                    catch (Exception exp) {
                        System.out.println("\n WANING: Could not Parse Input String:" + newValue);
                    }
                    Object[] add_obj = new Object[matchedrow[i].length + 1];
                    add_obj[0] = replace;
                    for (int k = 0; k < matchedrow[i].length; ++k) {
                        add_obj[k + 1] = matchedrow[i][k];
                    }
                    rt.addFillRow(add_obj);
                    this.mrowI.add(mrowC++, matchedIndexVal);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("\n Exception :" + ex.getMessage());
                }
            }
        }
        return rt;
    }
}

