/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.ndtable;

import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.JOptionPane;
import org.arrah.framework.ndtable.ColumnAttr;
import org.arrah.framework.ndtable.ReportTableModel;

public class CSVtoReportTableModel {
    private int previewRowNumber = 15;
    private int displayRowNumber = 100;
    private int skipRowNumber = 0;
    private String FIELD_SEP = ",";
    private String COMMENT_STR = "#";
    private int fixedcolWidth = 0;
    private File f = null;
    private BufferedReader br;
    private Vector<ColumnAttr> vc;
    private boolean fieldSelection = false;
    private boolean adv_fieldSelection = false;
    private boolean fixedWidthSelection = false;
    private boolean adv_widthSelection = false;
    private boolean commentSelection = false;
    private boolean skipRowSelection = false;
    private boolean previewRowSelection = false;
    private boolean displayRowSelection = false;
    private boolean firstRowColumnName = false;
    private boolean strictParsing = false;

    public CSVtoReportTableModel(File fileToLoad) {
        this.f = fileToLoad;
        this.vc = new Vector();
    }

    public ReportTableModel loadFileIntoTable(int is_preview) {
        ReportTableModel showT = null;
        String line = null;
        boolean headerSet = false;
        int lineCount = 0;
        int headerSize = 0;
        int vec_c = this.vc == null ? 0 : this.vc.size();
        int validLine = 0;
        int totalLine = 0;
        if (this.previewRowSelection && this.previewRowNumber <= 0) {
            this.previewRowNumber = 15;
        }
        if (this.displayRowSelection && this.displayRowNumber <= 0) {
            this.displayRowNumber = 100;
        }
        if (this.skipRowSelection && this.skipRowNumber <= 0) {
            this.skipRowSelection = false;
        }
        if (this.commentSelection && (this.COMMENT_STR == null || this.COMMENT_STR.equals(""))) {
            this.commentSelection = false;
        }
        if (this.fieldSelection && (this.FIELD_SEP == null || this.FIELD_SEP.equals(""))) {
            this.FIELD_SEP = ";";
        }
        try {
            this.br = new BufferedReader(new FileReader(this.f));
            while ((line = this.br.readLine()) != null) {
                ArrayList<String> columnA;
                int colI;
                block36: {
                    ++totalLine;
                    if (this.commentSelection && line.startsWith(this.COMMENT_STR)) continue;
                    if ((line = line.trim()).equals("")) {
                        System.out.println("Empty Record at:" + totalLine);
                        continue;
                    }
                    if (this.skipRowSelection && ++lineCount <= this.skipRowNumber) continue;
                    if (this.displayRowSelection && validLine >= this.displayRowNumber) break;
                    colI = 0;
                    columnA = new ArrayList<String>();
                    int lineIndex = 0;
                    int lineLength = line.length();
                    boolean lastCol = false;
                    if (this.fieldSelection) {
                        columnA.clear();
                        while (true) {
                            String[] f_column;
                            if (this.adv_fieldSelection) {
                                if (colI < vec_c) {
                                    this.FIELD_SEP = this.vc.get(colI).getSep();
                                    if (this.FIELD_SEP == null || this.FIELD_SEP.equals("")) {
                                        lastCol = true;
                                    }
                                } else {
                                    lastCol = true;
                                }
                            }
                            try {
                                f_column = !lastCol ? line.split(this.FIELD_SEP, 2) : new String[]{line};
                            }
                            catch (PatternSyntaxException pe) {
                                JOptionPane.showMessageDialog(null, pe.getMessage(), "Regex Error", 0);
                                return null;
                            }
                            columnA.add(colI, f_column[0]);
                            ++colI;
                            if (f_column.length != 1 && f_column[1] != null && !f_column[1].equals("")) {
                                line = f_column[1];
                                continue;
                            }
                            break block36;
                            break;
                        }
                    }
                    columnA.clear();
                    int colWidth = 0;
                    if (this.fixedWidthSelection) {
                        colWidth = this.fixedcolWidth;
                    }
                    if (colWidth <= 0) {
                        colWidth = lineLength;
                    }
                    while (lineIndex < lineLength) {
                        if (this.adv_widthSelection) {
                            if (colI < vec_c) {
                                colWidth = this.vc.get(colI).getWidth();
                                if (colWidth <= 0) {
                                    colWidth = lineLength - lineIndex;
                                }
                            } else {
                                colWidth = lineLength - lineIndex;
                            }
                        }
                        String column = lineIndex + colWidth < lineLength ? line.substring(lineIndex, lineIndex + colWidth) : line.substring(lineIndex, lineLength);
                        lineIndex += colWidth;
                        columnA.add(colI, column);
                        ++colI;
                    }
                }
                if (!headerSet) {
                    if (this.firstRowColumnName) {
                        headerSize = columnA.size();
                        showT = is_preview == 0 ? new ReportTableModel(columnA.toArray()) : new ReportTableModel(columnA.toArray(), true, true);
                        headerSet = true;
                        continue;
                    }
                    ArrayList<String> headerA = new ArrayList<String>();
                    for (int i = 0; i < vec_c; ++i) {
                        ColumnAttr cob = this.vc.get(i);
                        String headerN = cob.getName();
                        if (headerN == null || headerN.equals("")) {
                            headerN = "Column " + (i + 1);
                        }
                        headerA.add(i, headerN);
                    }
                    showT = is_preview == 0 ? new ReportTableModel(headerA.toArray()) : new ReportTableModel(headerA.toArray(), true, true);
                    headerSize = vec_c;
                    headerSet = true;
                }
                if (this.strictParsing && colI != headerSize) {
                    System.out.println("\n Skipped:" + columnA);
                    continue;
                }
                if (colI == headerSize) {
                    showT.addFillRow(columnA.toArray());
                } else if (colI < headerSize) {
                    while (colI < headerSize) {
                        columnA.add(colI++, null);
                    }
                    showT.addFillRow(columnA.toArray());
                } else {
                    while (colI > headerSize) {
                        columnA.remove(--colI);
                    }
                    showT.addFillRow(columnA.toArray());
                }
                if (is_preview != 0 || ++validLine != this.previewRowNumber) continue;
                break;
            }
            System.out.println("\n" + validLine + " of Total " + totalLine + " Parsed SuccessFully.");
            this.br.close();
        }
        catch (IOException ie) {
            System.out.println("\n IO Error:" + ie.getMessage());
            return null;
        }
        return showT;
    }

    public void setFieldSelection(boolean fieldSelection, String field_sep) {
        this.fieldSelection = fieldSelection;
        this.FIELD_SEP = field_sep;
    }

    public boolean isFieldSelection() {
        return this.fieldSelection;
    }

    public void setCommentSelection(boolean commentSelection, String comment_str) {
        this.commentSelection = commentSelection;
        this.COMMENT_STR = comment_str;
    }

    public boolean isCommentSelection() {
        return this.commentSelection;
    }

    public void setSkipRowSelection(boolean skipRowSelection, int skipRows) {
        this.skipRowSelection = skipRowSelection;
        this.skipRowNumber = skipRows;
    }

    public boolean isSkipRowSelection() {
        return this.skipRowSelection;
    }

    public void setPreviewRowSelection(boolean previewRowSelection, int previewRows) {
        this.previewRowSelection = previewRowSelection;
        this.previewRowNumber = previewRows;
    }

    public boolean isPreviewRowSelection() {
        return this.previewRowSelection;
    }

    public void setDisplayRowSelection(boolean displayRowSelection, int displayRows) {
        this.displayRowSelection = displayRowSelection;
        this.displayRowNumber = displayRows;
    }

    public boolean isDisplayRowSelection() {
        return this.displayRowSelection;
    }

    public void setFirstRowColumnName(boolean firstRowColumnName, Vector<ColumnAttr> column_v) {
        this.firstRowColumnName = firstRowColumnName;
        this.vc = column_v;
    }

    public boolean isFirstRowColumnName() {
        return this.firstRowColumnName;
    }

    public void setStrictParsing(boolean strictParsing) {
        this.strictParsing = strictParsing;
    }

    public boolean isStrictParsing() {
        return this.strictParsing;
    }

    public void setAdv_fieldSelection(boolean adv_fieldSelection, Vector<ColumnAttr> column_v) {
        this.adv_fieldSelection = adv_fieldSelection;
        this.vc = column_v;
    }

    public boolean isAdv_fieldSelection() {
        return this.adv_fieldSelection;
    }

    public void setAdv_widthSelection(boolean adv_widthSelection, Vector<ColumnAttr> column_v) {
        this.adv_widthSelection = adv_widthSelection;
        this.vc = column_v;
    }

    public boolean isAdv_widthSelection() {
        return this.adv_widthSelection;
    }

    public void setfixedWidthSelection(boolean fixedwidthSelection, int fixedWidth) {
        this.fixedWidthSelection = fixedwidthSelection;
        this.fixedcolWidth = fixedWidth;
    }

    public boolean isfixedWidthSelection() {
        return this.fixedWidthSelection;
    }

    public ReportTableModel loadOpenCSVIntoTable() {
        ReportTableModel showT = null;
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(this.f));
            String[] nextLine = null;
            int colL = 0;
            boolean headerset = false;
            while ((nextLine = reader.readNext()) != null) {
                if (!headerset) {
                    showT = new ReportTableModel(nextLine, true, true);
                    headerset = true;
                    colL = nextLine.length;
                    continue;
                }
                if (colL == nextLine.length) {
                    showT.addFillRow(nextLine);
                    continue;
                }
                System.out.println("No of Column not matching:" + nextLine);
            }
            reader.close();
        }
        catch (IOException ie) {
            System.out.println("\n IO Error:" + ie.getMessage());
            return null;
        }
        return showT;
    }
}

