/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.ndtable;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_NewConn;
import org.arrah.framework.rdbms.Rdbms_conn;

public class ResultsetToRTM {
    public static ReportTableModel getSQLValue(ResultSet rs, boolean format) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        String[] col_name = new String[numberOfColumns];
        int[] col_type = new int[numberOfColumns];
        for (int i = 1; i < numberOfColumns + 1; ++i) {
            col_name[i - 1] = rsmd.getColumnLabel(i);
            col_type[i - 1] = rsmd.getColumnType(i);
        }
        ReportTableModel rt = format ? new ReportTableModel(col_name, false, true) : new ReportTableModel(col_name, false, false);
        while (rs.next()) {
            Vector<Object> row_v = new Vector<Object>();
            block18: for (int i = 1; i < numberOfColumns + 1; ++i) {
                switch (col_type[i - 1]) {
                    case -6: 
                    case 4: 
                    case 5: {
                        int val = rs.getInt(i);
                        if (rs.wasNull()) {
                            row_v.add(i - 1, null);
                            continue block18;
                        }
                        row_v.add(i - 1, val);
                        continue block18;
                    }
                    case -5: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        double valD = rs.getDouble(i);
                        if (rs.wasNull()) {
                            row_v.add(i - 1, null);
                            continue block18;
                        }
                        row_v.add(i - 1, valD);
                        continue block18;
                    }
                    case 6: {
                        double valF = rs.getFloat(i);
                        if (rs.wasNull()) {
                            row_v.add(i - 1, null);
                            continue block18;
                        }
                        row_v.add(i - 1, valF);
                        continue block18;
                    }
                    case 2005: {
                        row_v.add(i - 1, rs.getClob(i));
                        continue block18;
                    }
                    case 2004: {
                        row_v.add(i - 1, rs.getBlob(i));
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        row_v.add(i - 1, new Boolean(rs.getBoolean(i)));
                        continue block18;
                    }
                    case 91: {
                        row_v.add(i - 1, rs.getDate(i));
                        continue block18;
                    }
                    case 92: {
                        row_v.add(i - 1, rs.getTime(i));
                        continue block18;
                    }
                    case 93: {
                        row_v.add(i - 1, rs.getTimestamp(i));
                        continue block18;
                    }
                    case 2003: {
                        row_v.add(i - 1, rs.getArray(i));
                        continue block18;
                    }
                    case 2006: {
                        row_v.add(i - 1, rs.getRef(i));
                        continue block18;
                    }
                    case -2: {
                        row_v.add(i - 1, rs.getByte(i));
                        continue block18;
                    }
                    case -4: 
                    case -3: {
                        row_v.add(i - 1, rs.getBytes(i));
                        continue block18;
                    }
                    case 0: 
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2001: 
                    case 2002: {
                        row_v.add(i - 1, rs.getObject(i));
                        continue block18;
                    }
                    default: {
                        row_v.add(i - 1, rs.getString(i));
                    }
                }
            }
            rt.addFillRow(row_v);
        }
        return rt;
    }

    public static synchronized Vector<BigInteger> getMD5Value(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        String[] col_name = new String[numberOfColumns];
        int[] col_type = new int[numberOfColumns];
        Vector<BigInteger> row_v = new Vector<BigInteger>();
        for (int i = 1; i < numberOfColumns + 1; ++i) {
            col_name[i - 1] = rsmd.getColumnLabel(i);
            col_type[i - 1] = rsmd.getColumnType(i);
        }
        while (rs.next()) {
            String rowString = "";
            block18: for (int i = 1; i < numberOfColumns + 1; ++i) {
                switch (col_type[i - 1]) {
                    case -6: 
                    case 4: 
                    case 5: {
                        rowString = rowString + new Integer(rs.getInt(i)).toString();
                        continue block18;
                    }
                    case -5: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        rowString = rowString + new Double(rs.getDouble(i)).toString();
                        continue block18;
                    }
                    case 6: {
                        rowString = rowString + new Float(rs.getFloat(i)).toString();
                        continue block18;
                    }
                    case 2005: {
                        rowString = rowString + rs.getClob(i).toString();
                        continue block18;
                    }
                    case 2004: {
                        rowString = rowString + rs.getBlob(i).toString();
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        rowString = rowString + new Boolean(rs.getBoolean(i)).toString();
                        continue block18;
                    }
                    case 91: {
                        rowString = rowString + rs.getDate(i).toString();
                        continue block18;
                    }
                    case 92: {
                        rowString = rowString + rs.getTime(i).toString();
                        continue block18;
                    }
                    case 93: {
                        rowString = rowString + rs.getTimestamp(i).toString();
                        continue block18;
                    }
                    case 2003: {
                        rowString = rowString + rs.getArray(i).toString();
                        continue block18;
                    }
                    case 2006: {
                        rowString = rowString + rs.getRef(i).toString();
                        continue block18;
                    }
                    case -2: {
                        rowString = rowString + rs.getByte(i);
                        continue block18;
                    }
                    case -4: 
                    case -3: {
                        rowString = rowString + rs.getBytes(i).toString();
                        continue block18;
                    }
                    case 0: 
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2001: 
                    case 2002: {
                        rowString = rowString + rs.getObject(i).toString();
                        continue block18;
                    }
                    default: {
                        rowString = rowString + rs.getString(i);
                    }
                }
            }
            BigInteger number = ResultsetToRTM.getMD5(rowString);
            if (number == null) continue;
            row_v.add(number);
        }
        return row_v;
    }

    public static BigInteger getMD5(String input) {
        BigInteger number = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            number = new BigInteger(1, messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return number;
    }

    public static synchronized ReportTableModel matchMD5Value(ResultSet rs, Vector<BigInteger> hashValue, boolean match) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int numberOfColumns = rsmd.getColumnCount();
        String[] col_name = new String[numberOfColumns];
        int[] col_type = new int[numberOfColumns];
        for (int i = 1; i < numberOfColumns + 1; ++i) {
            col_name[i - 1] = rsmd.getColumnLabel(i);
            col_type[i - 1] = rsmd.getColumnType(i);
        }
        ReportTableModel rt = new ReportTableModel(col_name, false, true);
        while (rs.next()) {
            String rowString = "";
            Vector<Object> row_v = new Vector<Object>();
            block18: for (int i = 1; i < numberOfColumns + 1; ++i) {
                switch (col_type[i - 1]) {
                    case -6: 
                    case 4: 
                    case 5: {
                        Integer intval = new Integer(rs.getInt(i));
                        row_v.add(i - 1, intval);
                        rowString = rowString + intval.toString();
                        continue block18;
                    }
                    case -5: 
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        Double dobval = new Double(rs.getDouble(i));
                        row_v.add(i - 1, dobval);
                        rowString = rowString + dobval.toString();
                        continue block18;
                    }
                    case 6: {
                        Float floval = new Float(rs.getFloat(i));
                        row_v.add(i - 1, floval);
                        rowString = rowString + floval.toString();
                        continue block18;
                    }
                    case 2005: {
                        Clob cloval = rs.getClob(i);
                        row_v.add(i - 1, cloval);
                        rowString = rowString + cloval.toString();
                        continue block18;
                    }
                    case 2004: {
                        Blob bloval = rs.getBlob(i);
                        row_v.add(i - 1, bloval);
                        rowString = rowString + bloval.toString();
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        Boolean booval = new Boolean(rs.getBoolean(i));
                        row_v.add(i - 1, booval);
                        rowString = rowString + booval.toString();
                        continue block18;
                    }
                    case 91: {
                        Date datval = rs.getDate(i);
                        row_v.add(i - 1, datval);
                        rowString = rowString + datval.toString();
                        continue block18;
                    }
                    case 92: {
                        Time timval = rs.getTime(i);
                        row_v.add(i - 1, timval);
                        rowString = rowString + timval.toString();
                        continue block18;
                    }
                    case 93: {
                        Timestamp tstval = rs.getTimestamp(i);
                        row_v.add(i - 1, tstval);
                        rowString = rowString + tstval.toString();
                        continue block18;
                    }
                    case 2003: {
                        Array araval = rs.getArray(i);
                        row_v.add(i - 1, araval);
                        rowString = rowString + araval.toString();
                        continue block18;
                    }
                    case 2006: {
                        Ref refval = rs.getRef(i);
                        row_v.add(i - 1, refval);
                        rowString = rowString + refval.toString();
                        continue block18;
                    }
                    case -2: {
                        byte bytval = rs.getByte(i);
                        row_v.add(i - 1, bytval);
                        rowString = rowString + bytval;
                        continue block18;
                    }
                    case -4: 
                    case -3: {
                        byte[] btsval = rs.getBytes(i);
                        row_v.add(i - 1, btsval);
                        rowString = rowString + btsval.toString();
                        continue block18;
                    }
                    case 0: 
                    case 70: 
                    case 1111: 
                    case 2000: 
                    case 2001: 
                    case 2002: {
                        Object objval = rs.getObject(i);
                        row_v.add(i - 1, objval);
                        rowString = rowString + objval.toString();
                        continue block18;
                    }
                    default: {
                        String strval = rs.getString(i);
                        row_v.add(i - 1, strval);
                        rowString = rowString + strval;
                    }
                }
            }
            BigInteger number = ResultsetToRTM.getMD5(rowString);
            if (number == null) continue;
            if (match && hashValue.contains(number)) {
                rt.addFillRow(row_v);
            }
            if (match || hashValue.contains(number)) continue;
            rt.addFillRow(row_v);
        }
        return rt;
    }

    public static synchronized ReportTableModel compareTable(String lTable, Hashtable<String, String> newDBParam, String rtable, boolean match) throws SQLException {
        ReportTableModel rtm = null;
        Vector<?>[] avector = Rdbms_conn.populateColumn(lTable, null);
        QueryBuilder qb = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), lTable, Rdbms_conn.getDBType());
        String s1 = qb.get_selCol_query(avector[0].toArray(), "");
        Rdbms_conn.openConn();
        ResultSet resultset = Rdbms_conn.runQuery(s1);
        Vector<BigInteger> hashNumber = ResultsetToRTM.getMD5Value(resultset);
        resultset.close();
        Rdbms_conn.closeConn();
        Rdbms_NewConn newConn = new Rdbms_NewConn(newDBParam);
        qb = new QueryBuilder(newConn.getHValue("Database_DSN"), rtable, newConn.getDBType());
        Vector<?>[] avectorR = newConn.populateColumn(rtable, null);
        s1 = qb.get_selCol_query(avectorR[0].toArray(), "");
        if (newConn.openConn()) {
            ResultSet resultset_new = newConn.runQuery(s1);
            rtm = ResultsetToRTM.matchMD5Value(resultset_new, hashNumber, match);
            resultset_new.close();
            newConn.closeConn();
        }
        return rtm;
    }
}

