/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.profile;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.arrah.framework.ndtable.ReportTableModel;
import org.arrah.framework.rdbms.QueryBuilder;
import org.arrah.framework.rdbms.Rdbms_conn;
import org.arrah.framework.rdbms.SqlType;
import org.arrah.framework.rdbms.TableRelationInfo;

public class TableMetaInfo {
    private static DatabaseMetaData dbmd;

    public static ReportTableModel populateTable(int i, int j, int k, ReportTableModel reporttable) {
        try {
            Rdbms_conn.openConn();
            dbmd = Rdbms_conn.getMetaData();
            switch (i) {
                case 1: {
                    reporttable = TableMetaInfo.IndexQuery(j, k, reporttable);
                    break;
                }
                case 2: {
                    reporttable = TableMetaInfo.MetaDataQuery(j, k, reporttable);
                    break;
                }
                case 3: {
                    reporttable = TableMetaInfo.PrivilegeQuery(j, k, reporttable);
                    break;
                }
                case 4: {
                    reporttable = TableMetaInfo.DataQuery(j, k, reporttable);
                }
            }
            Rdbms_conn.closeConn();
        }
        catch (SQLException sqlexception) {
            System.out.println(sqlexception.getMessage());
            System.out.println("\n WARNING: Exception in Variable Query Panel ");
            return reporttable;
        }
        return reporttable;
    }

    public static Vector<?>[] populateTable(int i, int j, int k, Vector<?>[] avector) {
        try {
            Rdbms_conn.openConn();
            dbmd = Rdbms_conn.getMetaData();
            switch (i) {
                case 5: {
                    avector = TableMetaInfo.ColumnDataQuery(j, k, avector);
                }
            }
            Rdbms_conn.closeConn();
        }
        catch (SQLException sqlexception) {
            System.out.println(sqlexception.getMessage());
            System.out.println("\n WARNING: Exception in Variable Column Data Query Panel ");
            return avector;
        }
        return avector;
    }

    private static ReportTableModel IndexQuery(int i, int j, ReportTableModel reporttable) throws SQLException {
        String s = Rdbms_conn.getHValue("Database_Catalog");
        s = "";
        String s1 = Rdbms_conn.getHValue("Database_SchemaPattern");
        s = s.compareTo("") != 0 ? s : null;
        s1 = s1.compareTo("") != 0 ? s1 : null;
        Vector<String> vector = Rdbms_conn.getTable();
        if (reporttable == null) {
            reporttable = new ReportTableModel(new String[]{"Table", "Column", "Index", "Type", "Qualifier", "IsUnique", "Asc/Dsc", "Cardinality", "Pages", "Filter"});
        } else {
            reporttable.cleanallRow();
        }
        try {
            for (int k = i; k < j; ++k) {
                String s2 = vector.elementAt(k);
                ResultSet resultset = dbmd.getIndexInfo(s, s1, s2, false, true);
                while (resultset.next()) {
                    boolean flag = resultset.getBoolean(4);
                    String s3 = !flag ? "False" : "True";
                    String s4 = resultset.getString(5);
                    String s5 = resultset.getString(6);
                    String s6 = "";
                    short word0 = resultset.getShort(7);
                    switch (word0) {
                        case 0: {
                            s6 = "Statistic";
                            break;
                        }
                        case 1: {
                            s6 = "Clustered";
                            break;
                        }
                        case 2: {
                            s6 = "Hashed";
                            break;
                        }
                        default: {
                            s6 = "Type UnKnown";
                        }
                    }
                    String s7 = resultset.getString(9);
                    String s8 = resultset.getString(10);
                    String s9 = resultset.getString(11);
                    String s10 = resultset.getString(12);
                    String s11 = resultset.getString(13);
                    if (s7 == null || s5 == null) continue;
                    String[] as = new String[]{s2, s7, s5, s6, s4, s3, s8, s9, s10, s11};
                    reporttable.addFillRow(as);
                }
                resultset.close();
            }
        }
        catch (SQLException ee) {
            System.out.println("Exception:" + ee.getMessage());
            return reporttable;
        }
        return reporttable;
    }

    private static ReportTableModel MetaDataQuery(int i, int j, ReportTableModel reporttable) throws SQLException {
        String s = Rdbms_conn.getHValue("Database_SchemaPattern");
        String s1 = Rdbms_conn.getHValue("Database_Catalog");
        s1 = "";
        s1 = s1.compareTo("") != 0 ? s1 : null;
        s = s.compareTo("") != 0 ? s : null;
        Vector<String> vector = Rdbms_conn.getTable();
        ResultSet resultset = null;
        if (reporttable == null) {
            reporttable = new ReportTableModel(new String[]{"Table", "Column", "DBType", "SQLType", "Size", "Precision", "Radix", "Remark", "Default", "Bytes", "Ordinal Pos", "Nullable"});
        } else {
            reporttable.cleanallRow();
        }
        for (int k = i; k < j; ++k) {
            String s2 = vector.elementAt(k);
            resultset = dbmd.getColumns(s1, s, s2, null);
            while (resultset.next()) {
                String s3 = resultset.getString(3);
                if (!s3.equals(s2)) continue;
                String s4 = resultset.getString(4);
                int i5 = resultset.getInt(5);
                String s52 = SqlType.getTypeName(i5);
                String s5 = resultset.getString(6);
                String s6 = resultset.getString(7);
                String s7 = resultset.getString(9);
                String s8 = resultset.getString(10);
                String s9 = resultset.getString(12);
                String s10 = resultset.getString(13);
                String s11 = resultset.getString(16);
                String s12 = resultset.getString(17);
                String s13 = resultset.getString(18);
                String[] as = new String[]{s2, s4, s5, s52, s6, s7, s8, s9, s10, s11, s12, s13};
                reporttable.addFillRow(as);
            }
            resultset.close();
        }
        return reporttable;
    }

    private static ReportTableModel PrivilegeQuery(int i, int j, ReportTableModel reporttable) throws SQLException {
        String s = Rdbms_conn.getHValue("Database_SchemaPattern");
        String s1 = Rdbms_conn.getHValue("Database_Catalog");
        s1 = "";
        s1 = s1.compareTo("") != 0 ? s1 : null;
        s = s.compareTo("") != 0 ? s : null;
        int k = 0;
        Vector<String> vector = Rdbms_conn.getTable();
        ResultSet resultset = null;
        if (reporttable == null) {
            reporttable = new ReportTableModel(new String[]{"Table", "Grantor", "Grantee", "Privileges", "Grantable"});
        } else {
            reporttable.cleanallRow();
        }
        for (int l = i; l < j; ++l) {
            String s2 = vector.elementAt(l);
            resultset = dbmd.getTablePrivileges(s1, s, s2);
            while (resultset.next()) {
                String s3 = resultset.getString(3);
                if (!s3.equals(s2)) continue;
                ++k;
                String s4 = resultset.getString(4);
                String s5 = resultset.getString(5);
                String s6 = resultset.getString(6);
                String s7 = resultset.getString(7);
                String[] as = new String[]{s3, s4, s5, s6, s7};
                reporttable.addFillRow(as);
            }
            resultset.close();
        }
        if (k == 0) {
            System.out.println("Tables do not Exist \n Or You might not have permisson to run this query ");
        }
        return reporttable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReportTableModel DataQuery(int i, int j, ReportTableModel reporttable) throws SQLException {
        String s = Rdbms_conn.getHValue("Database_SchemaPattern");
        String s1 = Rdbms_conn.getHValue("Database_Catalog");
        s1 = "";
        String s2 = Rdbms_conn.getHValue("Database_DSN");
        s1 = s1.compareTo("") != 0 ? s1 : null;
        s = s.compareTo("") != 0 ? s : null;
        Vector<String> vector = Rdbms_conn.getTable();
        String s3 = Rdbms_conn.getDBType();
        if (reporttable == null) {
            reporttable = new ReportTableModel(new String[]{"Table", "Column", "Record", "Unique", "Pattern", "Null", "Zero", "Empty"});
        } else {
            reporttable.cleanallRow();
        }
        Class<Rdbms_conn> clazz = Rdbms_conn.class;
        synchronized (Rdbms_conn.class) {
            for (int k = i; k < j; ++k) {
                try {
                    if (s3.compareToIgnoreCase("oracle_native") == 0) {
                        Rdbms_conn.openConn();
                        dbmd = Rdbms_conn.getMetaData();
                    }
                    String s17 = vector.elementAt(k);
                    Vector<String> vector1 = new Vector<String>();
                    ResultSet resultset = dbmd.getColumns(s1, s, s17, null);
                    while (resultset.next()) {
                        String s18 = resultset.getString(3);
                        if (!s18.equals(s17)) continue;
                        String s19 = resultset.getString(4);
                        vector1.add(s19);
                    }
                    resultset.close();
                    if (s3.compareToIgnoreCase("oracle_native") == 0) {
                        Rdbms_conn.closeConn();
                    }
                    Enumeration enumeration = vector1.elements();
                    while (enumeration.hasMoreElements()) {
                        String s10 = "0";
                        String s11 = "0";
                        String s12 = "0";
                        String s13 = "0";
                        String s14 = "0";
                        String s15 = "0";
                        String s20 = (String)enumeration.nextElement();
                        QueryBuilder querybuilder = new QueryBuilder(s2, s17, s20, s3);
                        String s4 = querybuilder.count_query_w(false, "row_count");
                        String s5 = querybuilder.count_query_w(true, "row_count");
                        String s6 = querybuilder.get_nullCount_query_w("Null");
                        String s7 = querybuilder.get_zeroCount_query_w("0");
                        String s8 = querybuilder.get_zeroCount_query_w("''");
                        String s9 = querybuilder.get_pattern_query();
                        if (s3.compareToIgnoreCase("oracle_native") == 0) {
                            Rdbms_conn.openConn();
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s4);
                            while (resultset.next()) {
                                s10 = resultset.getString("row_count");
                            }
                            resultset.close();
                        }
                        catch (SQLException sqlexception) {
                            s10 = "N/A";
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s5);
                            while (resultset.next()) {
                                s11 = resultset.getString("row_count");
                            }
                            resultset.close();
                        }
                        catch (SQLException sqlexception1) {
                            s11 = "N/A";
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s6);
                            while (resultset.next()) {
                                s12 = resultset.getString("equal_count");
                            }
                            resultset.close();
                        }
                        catch (NullPointerException | SQLException sqlexception2) {
                            s12 = "N/A";
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s7);
                            while (resultset.next()) {
                                s13 = resultset.getString("equal_count");
                            }
                            resultset.close();
                        }
                        catch (SQLException sqlexception3) {
                            s13 = "N/A";
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s8);
                            while (resultset.next()) {
                                s14 = resultset.getString("equal_count");
                            }
                            resultset.close();
                        }
                        catch (SQLException sqlexception4) {
                            s14 = "N/A";
                        }
                        try {
                            resultset = Rdbms_conn.runQuery(s9);
                            while (resultset.next()) {
                                s15 = resultset.getString("row_count");
                            }
                            resultset.close();
                        }
                        catch (SQLException sqlexception5) {
                            s15 = "N/A";
                        }
                        String[] as = new String[]{s17, s20, s10, s11, s15, s12, s13, s14};
                        if (s3.compareToIgnoreCase("oracle_native") == 0) {
                            Rdbms_conn.closeConn();
                        }
                        reporttable.addFillRow(as);
                    }
                    continue;
                }
                catch (SQLException ee) {
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return reporttable;
                }
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return reporttable;
        }
    }

    private static Vector<?>[] ColumnDataQuery(int i, int j, Vector[] avector) throws SQLException {
        String s = Rdbms_conn.getHValue("Database_SchemaPattern");
        String s1 = Rdbms_conn.getHValue("Database_Catalog");
        s1 = "";
        s1 = s1.compareTo("") != 0 ? s1 : null;
        s = s.compareTo("") != 0 ? s : null;
        Vector<String> vector = Rdbms_conn.getTable();
        avector = new Vector[]{new Vector(), new Vector()};
        int k = 0;
        for (int l = i; l < j; ++l) {
            String s2 = vector.elementAt(l);
            ResultSet resultset = dbmd.getColumns(s1, s, s2, null);
            while (resultset.next()) {
                String s3 = resultset.getString(3);
                if (!s3.equals(s2)) continue;
                String s4 = resultset.getString(4);
                int i1 = resultset.getInt(5);
                avector[0].add(k, s4);
                avector[1].add(k, new Integer(i1));
                ++k;
            }
            resultset.close();
        }
        return avector;
    }

    public static TableRelationInfo getTableRelationInfo(String cat, String sch, String table) throws SQLException {
        TableRelationInfo TableRelationInfo2 = new TableRelationInfo(table);
        Rdbms_conn.openConn();
        dbmd = Rdbms_conn.getMetaData();
        if (Rdbms_conn.getDBType().compareToIgnoreCase("ms_access") == 0) {
            ResultSet resultset9 = dbmd.getIndexInfo(cat, sch, table, false, true);
            while (resultset9.next()) {
                String s57 = resultset9.getString(9);
                String s63 = resultset9.getString(6);
                String s71 = resultset9.getString(3);
                if (s57 == null || s63 == null) continue;
                if (s63.compareToIgnoreCase("primarykey") == 0) {
                    TableRelationInfo2.pk[TableRelationInfo2.pk_c] = s57;
                    TableRelationInfo2.pk_index[TableRelationInfo2.pk_c] = s63;
                    TableRelationInfo2.hasPKey = true;
                    ++TableRelationInfo2.pk_c;
                    TableRelationInfo2.isRelated = true;
                    continue;
                }
                if (!s63.endsWith(table)) continue;
                TableRelationInfo2.fk[TableRelationInfo2.fk_c] = s57;
                TableRelationInfo2.fk_pKey[TableRelationInfo2.fk_c] = null;
                TableRelationInfo2.fk_pTable[TableRelationInfo2.fk_c] = s63.substring(0, s63.lastIndexOf(table));
                TableRelationInfo2.hasFKey = true;
                ++TableRelationInfo2.fk_c;
                TableRelationInfo2.isRelated = true;
            }
            resultset9.close();
        } else {
            int l3 = 0;
            ResultSet resultset10 = dbmd.getPrimaryKeys(cat, sch, table);
            while (resultset10.next()) {
                String s64 = resultset10.getString(4);
                String s72 = resultset10.getString(6);
                if (s64 == null || s72 == null) continue;
                TableRelationInfo2.pk[l3] = s64;
                TableRelationInfo2.pk_index[l3] = s72;
                TableRelationInfo2.hasPKey = true;
                ++l3;
                ++TableRelationInfo2.pk_c;
            }
            resultset10.close();
            l3 = 0;
            resultset10 = dbmd.getImportedKeys(cat, sch, table);
            while (resultset10.next()) {
                String s83;
                String s65 = resultset10.getString(3);
                String s73 = resultset10.getString(4);
                String s79 = resultset10.getString(7);
                TableRelationInfo2.fk[l3] = s83 = resultset10.getString(8);
                TableRelationInfo2.fk_pKey[l3] = s73;
                TableRelationInfo2.fk_pTable[l3] = s65;
                TableRelationInfo2.hasFKey = true;
                ++TableRelationInfo2.fk_c;
                TableRelationInfo2.isRelated = true;
                ++l3;
            }
            resultset10.close();
            l3 = 0;
            resultset10 = dbmd.getExportedKeys(cat, sch, table);
            while (resultset10.next()) {
                String s66 = resultset10.getString(3);
                String s74 = resultset10.getString(4);
                String s80 = resultset10.getString(7);
                String s84 = resultset10.getString(8);
                TableRelationInfo2.pk_ex[l3] = s74;
                TableRelationInfo2.pk_exKey[l3] = s84;
                TableRelationInfo2.pk_exTable[l3] = s80;
                TableRelationInfo2.hasExpKey = true;
                ++TableRelationInfo2.exp_c;
                TableRelationInfo2.isRelated = true;
                ++l3;
            }
            resultset10.close();
        }
        Rdbms_conn.closeConn();
        return TableRelationInfo2;
    }

    public static ReportTableModel tableKeyInfo(String table) throws SQLException {
        int i;
        String sch = Rdbms_conn.getHValue("Database_SchemaPattern");
        String cat = Rdbms_conn.getHValue("Database_Catalog");
        cat = "";
        cat = cat.compareTo("") != 0 ? cat : null;
        sch = sch.compareTo("") != 0 ? sch : null;
        TableRelationInfo TableRelationInfo2 = TableMetaInfo.getTableRelationInfo(cat, sch, table);
        ReportTableModel rtm = new ReportTableModel(new String[]{"Primary Key", "Foreign Key", "Foreign Table", "Exported Key", "Exported Table"});
        int rowI = 0;
        for (i = 0; i < TableRelationInfo2.pk_c; ++i) {
            rtm.addRow();
            rowI = i;
            rtm.setValueAt(TableRelationInfo2.pk[i], i, 0);
        }
        for (i = 0; i < TableRelationInfo2.fk_c; ++i) {
            if (i > rowI) {
                rtm.addRow();
                rowI = i;
            }
            rtm.setValueAt(TableRelationInfo2.fk[i], i, 1);
            rtm.setValueAt(TableRelationInfo2.fk_pTable[i], i, 2);
        }
        for (i = 0; i < TableRelationInfo2.exp_c; ++i) {
            if (i > rowI) {
                rtm.addRow();
                rowI = i;
            }
            rtm.setValueAt(TableRelationInfo2.pk_ex[i], i, 3);
            rtm.setValueAt(TableRelationInfo2.pk_exTable[i], i, 4);
        }
        return rtm;
    }

    public static ReportTableModel getSuperTableInfo(String cat, String sch, String _table) throws SQLException {
        ReportTableModel _rt = new ReportTableModel(new String[]{"Table", "Super Table"});
        Rdbms_conn.openConn();
        dbmd = Rdbms_conn.getMetaData();
        ResultSet rs = dbmd.getSuperTables(cat, sch, _table);
        while (rs.next()) {
            String table = rs.getString(3);
            if (!_table.equals(table)) continue;
            String[] row = new String[]{table, rs.getString(4)};
            _rt.addFillRow(row);
        }
        rs.close();
        Rdbms_conn.closeConn();
        return _rt;
    }

    public static ReportTableModel getColumnDefaultValue(String cat, String sch, String _table) throws SQLException {
        ReportTableModel _rt = new ReportTableModel(new String[]{"Column", "Default Value"});
        Rdbms_conn.openConn();
        dbmd = Rdbms_conn.getMetaData();
        ResultSet rs = dbmd.getColumns(cat, sch, _table, null);
        while (rs.next()) {
            String table = rs.getString(3);
            if (!_table.equals(table)) continue;
            String col = rs.getString(4);
            String def = rs.getString(13);
            String[] row = new String[]{col, def};
            _rt.addFillRow(row);
        }
        rs.close();
        Rdbms_conn.closeConn();
        return _rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ReportTableModel queryTable(String query, String tableName, Vector<String> colName) {
        ReportTableModel _rt = new ReportTableModel(new String[]{"Count", "Table"});
        QueryBuilder qb = new QueryBuilder(Rdbms_conn.getHValue("Database_DSN"), tableName, Rdbms_conn.getDBType());
        String toQuery = qb.get_like_table_cols(query, colName, true);
        int matcount = 0;
        if (toQuery == null || "".equals(toQuery)) {
            return _rt;
        }
        try {
            Class<Rdbms_conn> clazz = Rdbms_conn.class;
            synchronized (Rdbms_conn.class) {
                Rdbms_conn.openConn();
                ResultSet rs = Rdbms_conn.runQuery(toQuery);
                while (rs.next()) {
                    matcount = rs.getInt(1);
                }
                rs.close();
                Rdbms_conn.closeConn();
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
        }
        catch (SQLException ee) {
            System.out.println("\n ResultSet SQL Error :" + ee.getMessage());
        }
        {
            try {
                Rdbms_conn.closeConn();
            }
            catch (SQLException ee) {
                System.out.println("\n SQL Error:" + ee.getMessage());
            }
            Object[] obj = new Object[]{matcount, tableName};
            _rt.addFillRow(obj);
            return _rt;
        }
    }
}

