/*
 * Decompiled with CFR 0.152.
 */
package org.arrah.framework.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.arrah.framework.rdbms.QueryBuilder;

public class Rdbms_NewConn {
    private Connection conn;
    private String _d_type = "";
    private String _d_dsn = "";
    private String __d_protocol = "";
    private String _d_user = "";
    private String _d_passwd = "";
    private String _d_driver = "";
    private String _d_url = "";
    private Hashtable<String, String> _h;
    private Vector<String> table_v;
    private Vector<String> tableDesc_v;

    public Rdbms_NewConn(Hashtable<String, String> hashtable) throws SQLException {
        this.init(hashtable);
    }

    public boolean openConn() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            return true;
        }
        if (this._d_driver == null || this._d_driver.equals("")) {
            System.out.println("Driver Value Not Found - Check DB Driver field");
            System.out.println("\n ERROR: Driver Value Not Found");
            System.exit(0);
        }
        try {
            Class.forName(this._d_driver);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            System.out.println("Driver Class Not Found.");
            System.out.println("Look into System DSN if using jdbc:odbc bridge");
            System.out.println("Make sure Driver class is in classpath if using native");
            System.out.println("Driver Class Not Found:" + classnotfoundexception.getMessage());
            return false;
        }
        try {
            String s = this._d_url;
            this.conn = s == null || "".equals(s) ? (this._d_type.compareToIgnoreCase("oracle_native") == 0 ? DriverManager.getConnection(this.__d_protocol + ":@" + this._d_dsn, this._d_user, this._d_passwd) : DriverManager.getConnection(this.__d_protocol + ":" + this._d_dsn, this._d_user, this._d_passwd)) : DriverManager.getConnection(this._d_url, this._d_user, this._d_passwd);
        }
        catch (Exception exception) {
            System.out.println("\n ERROR:Connection can not be created");
            System.out.println("DSN:" + this._d_dsn);
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databasemetadata = null;
        if (this.conn == null || this.conn.isClosed()) {
            return null;
        }
        try {
            databasemetadata = this.conn.getMetaData();
        }
        catch (SQLException sqlexception) {
            System.out.println("\n ERROR: MetaData SQL Exception");
            System.out.println(sqlexception.getMessage());
        }
        return databasemetadata;
    }

    public void closeConn() throws SQLException {
        if (this._d_type.compareToIgnoreCase("oracle_native") == 0) {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        } else if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
    }

    public void exitConn() throws SQLException {
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
    }

    public PreparedStatement createQuery(String s) throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            return null;
        }
        PreparedStatement preparedstatement = this.conn.prepareStatement(s);
        return preparedstatement;
    }

    public ResultSet executePreparedQuery(PreparedStatement preparedstatement) throws SQLException {
        ResultSet resultset = preparedstatement.executeQuery();
        return resultset;
    }

    public ResultSet runQuery(String s) throws SQLException {
        if (s.indexOf(" ?") == -1) {
            Statement statement = this._d_type.compareToIgnoreCase("ms_access") == 0 || this._d_type.compareToIgnoreCase("oracle_odbc") == 0 || this._d_type.compareToIgnoreCase("hive") == 0 || this._d_type.compareToIgnoreCase("Informix") == 0 || this._d_type.compareToIgnoreCase("Splice") == 0 ? this.conn.createStatement() : (this._d_type.compareToIgnoreCase("db2") == 0 ? this.conn.createStatement(1003, 1007) : (this._d_type.compareToIgnoreCase("ms_access_jdbc") == 0 ? this.conn.createStatement(1005, 1008) : (this._d_type.compareToIgnoreCase("Others") == 0 ? this.conn.createStatement(Integer.parseInt(this.getHValue("Database_ResultsetType")), Integer.parseInt(this.getHValue("Database_ResultsetConcur"))) : this.conn.createStatement(1004, 1007))));
            ResultSet resultset = statement.executeQuery(s);
            return resultset;
        }
        PreparedStatement preparedstatement = this.conn.prepareStatement(s);
        Vector<?>[] dateVar = QueryBuilder.getDateCondition();
        for (int i = 0; i < dateVar[0].size(); ++i) {
            String s1 = (String)dateVar[1].get(i);
            if (s1.compareToIgnoreCase("time") == 0) {
                preparedstatement.setTime(i + 1, new Time(((Date)dateVar[0].get(i)).getTime()));
            }
            if (s1.compareToIgnoreCase("date") == 0) {
                preparedstatement.setDate(i + 1, new java.sql.Date(((Date)dateVar[0].get(i)).getTime()));
            }
            if (s1.compareToIgnoreCase("timestamp") != 0) continue;
            preparedstatement.setTimestamp(i + 1, new Timestamp(((Date)dateVar[0].get(i)).getTime()));
        }
        ResultSet resultset = preparedstatement.executeQuery();
        return resultset;
    }

    public ResultSet runQuery(String s, int i) throws SQLException {
        Statement statement = this._d_type.compareToIgnoreCase("ms_access") == 0 || this._d_type.compareToIgnoreCase("oracle_odbc") == 0 || this._d_type.compareToIgnoreCase("hive") == 0 || this._d_type.compareToIgnoreCase("Informix") == 0 || this._d_type.compareToIgnoreCase("Splice") == 0 ? this.conn.createStatement() : (this._d_type.compareToIgnoreCase("db2") == 0 ? this.conn.createStatement(1003, 1007) : (this._d_type.compareToIgnoreCase("ms_access_jdbc") == 0 ? this.conn.createStatement(1005, 1008) : (this._d_type.compareToIgnoreCase("Others") == 0 ? this.conn.createStatement(Integer.parseInt(this.getHValue("Database_ResultsetType")), Integer.parseInt(this.getHValue("Database_ResultsetConcur"))) : this.conn.createStatement(1004, 1007))));
        statement.setMaxRows(i);
        ResultSet resultset = statement.executeQuery(s);
        return resultset;
    }

    public int executeUpdate(String s) throws SQLException {
        Statement statement = this._d_type.compareToIgnoreCase("ms_access") == 0 || this._d_type.compareToIgnoreCase("oracle_odbc") == 0 || this._d_type.compareToIgnoreCase("hive") == 0 || this._d_type.compareToIgnoreCase("Informix") == 0 || this._d_type.compareToIgnoreCase("Splice") == 0 ? this.conn.createStatement() : (this._d_type.compareToIgnoreCase("db2") == 0 ? this.conn.createStatement(1003, 1007) : (this._d_type.compareToIgnoreCase("ms_access_jdbc") == 0 ? this.conn.createStatement(1005, 1008) : (this._d_type.compareToIgnoreCase("Others") == 0 ? this.conn.createStatement(Integer.parseInt(this.getHValue("Database_ResultsetType")), Integer.parseInt(this.getHValue("Database_ResultsetConcur"))) : this.conn.createStatement(1004, 1007))));
        return statement.executeUpdate(s);
    }

    public ResultSet execute(String s) throws SQLException {
        Statement statement = null;
        boolean flag = false;
        statement = this._d_type.compareToIgnoreCase("ms_access") == 0 || this._d_type.compareToIgnoreCase("oracle_odbc") == 0 || this._d_type.compareToIgnoreCase("hive") == 0 || this._d_type.compareToIgnoreCase("Informix") == 0 || this._d_type.compareToIgnoreCase("Splice") == 0 ? this.conn.createStatement() : (this._d_type.compareToIgnoreCase("db2") == 0 ? this.conn.createStatement(1003, 1007) : (this._d_type.compareToIgnoreCase("ms_access_jdbc") == 0 ? this.conn.createStatement(1005, 1008) : (this._d_type.compareToIgnoreCase("Others") == 0 ? this.conn.createStatement(Integer.parseInt(this.getHValue("Database_ResultsetType")), Integer.parseInt(this.getHValue("Database_ResultsetConcur"))) : this.conn.createStatement(1004, 1007))));
        flag = statement.execute(s);
        if (flag) {
            return statement.getResultSet();
        }
        return null;
    }

    private void init(Hashtable<String, String> hashtable) throws SQLException {
        this._d_type = hashtable.get("Database_Type");
        this._d_dsn = hashtable.get("Database_DSN");
        this.__d_protocol = hashtable.get("Database_Protocol");
        this._d_driver = hashtable.get("Database_Driver");
        this._d_user = hashtable.get("Database_User");
        this._d_passwd = hashtable.get("Database_Passwd");
        this._d_url = hashtable.get("Database_JDBC");
        this._h = hashtable;
        this.table_v = new Vector();
        this.tableDesc_v = new Vector();
        this.exitConn();
    }

    public String getDBType() {
        return this._d_type;
    }

    public String getHValue(String s) {
        return this._h.get(s);
    }

    public String setHValue(String key, String value) {
        return this._h.put(key, value);
    }

    public String checkAndReturnSql(String s) throws SQLException {
        Statement statement = null;
        this.conn.setAutoCommit(false);
        statement = this._d_type.compareToIgnoreCase("ms_access") == 0 || this._d_type.compareToIgnoreCase("oracle_odbc") == 0 || this._d_type.compareToIgnoreCase("hive") == 0 || this._d_type.compareToIgnoreCase("Informix") == 0 || this._d_type.compareToIgnoreCase("Splice") == 0 ? this.conn.createStatement() : (this._d_type.compareToIgnoreCase("db2") == 0 ? this.conn.createStatement(1003, 1007) : (this._d_type.compareToIgnoreCase("ms_access_jdbc") == 0 ? this.conn.createStatement(1005, 1008) : (this._d_type.compareToIgnoreCase("Others") == 0 ? this.conn.createStatement(Integer.parseInt(this.getHValue("Database_ResultsetType")), Integer.parseInt(this.getHValue("Database_ResultsetConcur"))) : this.conn.createStatement(1004, 1007))));
        statement.execute(s);
        this.conn.rollback();
        this.conn.setAutoCommit(true);
        return this.conn.nativeSQL(s);
    }

    public void populateTable() throws SQLException {
        String s = this._h.get("Database_SchemaPattern");
        String s1 = this._h.get("Database_TablePattern");
        String s2 = this._h.get("Database_TableType");
        String s3 = this._h.get("Database_Catalog");
        s3 = "";
        if (s == null || "".equals(s)) {
            s = null;
        }
        if (s3 == null || "".equals(s3)) {
            s3 = null;
        }
        if (s1 == null || "".equals(s1)) {
            s1 = null;
        }
        if (s2 == null || "".equals(s2)) {
            s2 = "TABLE";
        }
        if (this.openConn()) {
            DatabaseMetaData databasemetadata = this.getMetaData();
            ResultSet resultset = databasemetadata.getTables(s3, s, s1, s2.split(","));
            while (resultset.next()) {
                String s5 = resultset.getString(3);
                this.addTable(s5);
                String s7 = resultset.getString(5);
                this.addTableDesc(s7);
            }
            resultset.close();
            this.closeConn();
        } else {
            System.out.println("Table Can not be populated");
        }
    }

    public Vector<?>[] populateColumn(String tableName, String colPattern) throws SQLException {
        Vector[] avector = new Vector[]{new Vector(), new Vector()};
        String s = this._h.get("Database_SchemaPattern");
        String s1 = this._h.get("Database_TablePattern");
        String s3 = this._h.get("Database_Catalog");
        s3 = "";
        if (s == null || "".equals(s)) {
            s = null;
        }
        if (s3 == null || "".equals(s3)) {
            s3 = null;
        }
        if (s1 == null || "".equals(s1)) {
            s1 = null;
        }
        if (this.openConn()) {
            DatabaseMetaData databasemetadata = this.getMetaData();
            ResultSet resultset = databasemetadata.getColumns(s3, s, tableName, null);
            int k = 0;
            while (resultset.next()) {
                String s31 = resultset.getString(3);
                if (!s31.equals(tableName)) continue;
                String s4 = resultset.getString(4);
                int i1 = resultset.getInt(5);
                avector[0].add(k, s4);
                avector[1].add(k, new Integer(i1));
                ++k;
            }
            resultset.close();
            this.closeConn();
        } else {
            System.out.println("Column can not be populated");
        }
        return avector;
    }

    public void addTable(String s) {
        if (s == null) {
            return;
        }
        this.table_v.add(this.table_v.size(), s);
    }

    public void addTableDesc(String s) {
        if (s == null) {
            this.tableDesc_v.add(this.tableDesc_v.size(), "");
        } else {
            this.tableDesc_v.add(this.tableDesc_v.size(), s);
        }
    }

    public Vector<String> getTable() {
        return this.table_v;
    }

    public int getTableCount() {
        return this.table_v.size();
    }

    public Vector<String> getTableDesc() {
        return this.tableDesc_v;
    }

    public String getProtocol() {
        return this.__d_protocol;
    }

    public String getUser() {
        return this._d_user;
    }

    public String get_JDBC_URL() {
        return this._d_url;
    }

    public void set_JDBC_URL(String url) {
        this._d_url = url;
    }

    public String testConn() throws SQLException {
        String status = " Connection Failed. \n\n";
        this.exitConn();
        if (this._d_driver == null || this._d_driver.equals("")) {
            status = status + "Driver Value Not Found - Check DB Driver field";
            return status;
        }
        try {
            Class.forName(this._d_driver);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            status = status + "Driver Class Not Found. \n";
            status = status + "Look into System DSN if using jdbc:odbc bridge \n";
            status = status + "Make sure Driver class is in classpath if using native \n";
            status = status + "\n System Message:" + classnotfoundexception.getMessage();
            return status;
        }
        try {
            String s = this._d_url;
            this.conn = s == null || "".equals(s) ? (this._d_type.compareToIgnoreCase("oracle_native") == 0 ? DriverManager.getConnection(this.__d_protocol + ":@" + this._d_dsn, this._d_user, this._d_passwd) : DriverManager.getConnection(this.__d_protocol + ":" + this._d_dsn, this._d_user, this._d_passwd)) : DriverManager.getConnection(this._d_url, this._d_user, this._d_passwd);
        }
        catch (Exception exception) {
            status = status + "\n System Message:";
            status = status + exception.getMessage();
            return status;
        }
        status = "Connection Successful";
        return "Connection Successful";
    }
}

