/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.config.model.BasicConnectorBindingType;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.embedded.EmbeddedTestUtil;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.dqp.embedded.services.EmbeddedConfigurationService;
import com.metamatrix.vdb.runtime.BasicVDBDefn;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class TestEmbeddedConfigurationService
extends TestCase {
    EmbeddedConfigurationService service = null;

    protected void setUp() throws Exception {
        EmbeddedTestUtil.createTestDirectory();
        this.service = new EmbeddedConfigurationService();
        ApplicationEnvironment env = new ApplicationEnvironment();
        this.service.start(env);
        env.bindService("dqp.configuration", (ApplicationService)this.service);
    }

    protected void tearDown() throws Exception {
        this.service.stop();
    }

    public void testUseExtensionPath() throws Exception {
        this.service.userPreferences = EmbeddedTestUtil.getProperties();
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.useExtensionClasspath());
    }

    public void testUseExtensionPathFalse() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.remove("dqp.extensions");
        this.service.userPreferences = p;
        TestEmbeddedConfigurationService.assertFalse((boolean)this.service.useExtensionClasspath());
    }

    public void testGetAvailableVDBFiles() throws Exception {
        this.service.userPreferences = EmbeddedTestUtil.getProperties();
        HashMap vdbFiles = VDBConfigurationReader.loadVDBS((URL[])this.service.getVDBLocations());
        int count = vdbFiles.keySet().size();
        TestEmbeddedConfigurationService.assertEquals((int)2, (int)count);
        for (URL vdbURL : vdbFiles.keySet()) {
            String path = vdbURL.getPath();
            if (path.endsWith("QT_Ora9DS.vdb") || path.endsWith("Admin.vdb")) continue;
            TestEmbeddedConfigurationService.fail((String)"wrong file found");
        }
    }

    public void testGetConfigFileURL() throws Exception {
        this.service.userPreferences = EmbeddedTestUtil.getProperties();
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getConfigFile().toString().endsWith("dqp/config/ServerConfig.xml"));
    }

    public void testGetAlternateBinding2() throws Exception {
        Properties p;
        BasicConnectorBinding binding = new BasicConnectorBinding(new ConfigurationID("foo"), new ConnectorBindingID(new ConfigurationID("foo"), "foo"), new ComponentTypeID("foo type"));
        BasicConnectorBinding alternatebinding = new BasicConnectorBinding(new ConfigurationID("foo"), new ConnectorBindingID(new ConfigurationID("foo"), "foo"), new ComponentTypeID("foo type"));
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.loadedConnectorBindings.put("foo", alternatebinding);
        TestEmbeddedConfigurationService.assertTrue((this.service.getConnectorBinding(binding.getFullName()) == alternatebinding ? 1 : 0) != 0);
    }

    public void defer_testInitializeEncryption() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.setProperty("dqp.keystore", "Cluster.key");
        this.service.userPreferences = p;
        this.service.initializeEncryption();
        TestEmbeddedConfigurationService.assertFalse((boolean)(CryptoUtil.getDecryptor() instanceof NullCryptor));
    }

    public void testGetDefaultExtensionPath() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.remove("dqp.extensions");
        this.service.userPreferences = p;
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getDefaultExtensionPath().toString().endsWith("dqp/extensions/"));
    }

    public void testGetDirectoryToStoreVDBS() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getVDBSaveLocation().toString().endsWith("dqp/config/"));
    }

    public void testGetDirectoryToStoreVDBSByVDBName() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.setProperty("vdb.definition", "./config/QT_Ora9DS.vdb");
        this.service.userPreferences = p;
        this.service.initializeService(p);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        vdb.getConfigurationDef().setName("Foo");
        vdb.getConfigurationDef().setVersion("2");
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getVDBLocation(vdb).toString().endsWith("dqp/config/Foo_2.vdb"));
    }

    public void testGetFileToSaveNewFile() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        p.setProperty("vdb.definition", "./config/QT_Ora9DS.vdb");
        this.service.initializeService(p);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        vdb.getConfigurationDef().setName("Foo");
        vdb.getConfigurationDef().setVersion("2");
        URL f = this.service.getVDBLocation(vdb);
        TestEmbeddedConfigurationService.assertTrue((boolean)f.toString().endsWith("dqp/config/Foo_2.vdb"));
    }

    public void testGetFileAlreadyExisting() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        URL f = this.service.getVDBLocation(vdb);
        TestEmbeddedConfigurationService.assertTrue((boolean)f.getPath().endsWith("dqp/config/QT_Ora9DS.vdb"));
    }

    public void testGetFullyQualifiedPath() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("http://lib/foo.txt").toString().endsWith("http://lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("file:/c:/lib/foo.txt").toString().endsWith("file:/c:/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("/lib/foo.txt").toString().endsWith("mmfile:/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("../lib/foo.txt").toString().endsWith("mmfile:" + UnitTestUtil.getTestScratchPath() + "/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("lib/foo.txt").toString().endsWith("mmfile:" + UnitTestUtil.getTestScratchPath() + "/dqp/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("./lib/foo.txt").toString().endsWith("mmfile:" + UnitTestUtil.getTestScratchPath() + "/dqp/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("c:\\lib\\foo.txt").toString().endsWith("mmfile:/c:/lib/foo.txt"));
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getFullyQualifiedPath("c:/lib/foo.txt").toString().endsWith("mmfile:/c:/lib/foo.txt"));
    }

    public void testGetNextVdbVersion() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertEquals((int)2, (int)this.service.getNextVdbVersion("QT_Ora9DS"));
    }

    public void testDeleteInUseConnectorBinding() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        try {
            this.service.deleteConnectorBinding("BQT2 Oracle 9i Simple Cap");
            TestEmbeddedConfigurationService.fail((String)"Should not delete a binding in use..");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    public void testDeleteNonExistingConnectorBinding() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        try {
            this.service.deleteConnectorBinding("UNKNOWN");
            TestEmbeddedConfigurationService.fail((String)"Should not delete a binding UNKNOWN");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    public void testDeleteConnectorBinding() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        this.service.deleteVDB(this.service.getVDB("QT_Ora9DS", "1"));
        try {
            this.service.deleteConnectorBinding("QT_ORA9DS_1.BQT2 Oracle 9i Simple Cap");
            TestEmbeddedConfigurationService.fail((String)"must have failed because, delete of VDB should delete the binding too");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestEmbeddedConfigurationService.assertNull((Object)this.service.getConnectorBinding("QT_ORA9DS_1.BQT2 Oracle 9i Simple Cap"));
    }

    public void testDeleteConnectorType() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        try {
            this.service.deleteConnectorType("UNKNOWN");
        }
        catch (MetaMatrixComponentException e) {
            // empty catch block
        }
        TestEmbeddedConfigurationService.assertNotNull((Object)this.service.getConnectorType("File XMLSource Connector"));
        this.service.deleteConnectorType("File XMLSource Connector");
        try {
            this.service.deleteConnectorType("File XMLSource Connector");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    public void testDeleteConnectorTypeInUse() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertNotNull((Object)this.service.getConnectorType("Oracle ANSI JDBC Connector"));
        try {
            this.service.deleteConnectorType("Oracle ANSI JDBC Connector");
            TestEmbeddedConfigurationService.fail((String)"Must have failed in deleteing the in use connector type");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    public void testDeleteVDB() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        TestEmbeddedConfigurationService.assertNotNull((Object)vdb);
        this.service.deleteVDB(vdb);
        TestEmbeddedConfigurationService.assertNull((Object)this.service.getVDB("QT_Ora9DS", "1"));
    }

    public void testGetLogFile() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.setProperty("dqp.logFile", "./log/dqp.log");
        p.setProperty("dqp.logLevel", "1");
        this.service.userPreferences = p;
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getLogFile().toString().endsWith("/log/dqp.log"));
        TestEmbeddedConfigurationService.assertEquals((String)this.service.getLogLevel(), (String)"1");
    }

    public void testGetSystemProperties() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        Properties sp = this.service.getSystemProperties();
        TestEmbeddedConfigurationService.assertEquals((String)"50", (String)sp.getProperty("MaxCodeTables"));
        TestEmbeddedConfigurationService.assertEquals((String)"100", (String)sp.getProperty("MaxPlanCacheSize"));
        TestEmbeddedConfigurationService.assertEquals((String)"20000", (String)sp.getProperty("MaxFetchSize"));
    }

    public void testGetSystemConfiguration() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        TestEmbeddedConfigurationService.assertNull((Object)this.service.configurationModel);
        this.service.getSystemConfiguration();
        TestEmbeddedConfigurationService.assertNotNull((Object)this.service.configurationModel);
    }

    public void testGetSystemVDB() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertNotNull((Object)this.service.getSystemVdb());
    }

    public void testGetUDFFileName() throws Exception {
        Properties p = EmbeddedTestUtil.getProperties();
        p.setProperty("dqp.userDefinedFunctionsFile", "./lib/foo.txt");
        this.service.userPreferences = p;
        TestEmbeddedConfigurationService.assertTrue((boolean)this.service.getUDFFile().toString().endsWith(UnitTestUtil.getTestScratchPath() + "/dqp/lib/foo.txt"));
    }

    public void testGetVDBs() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertTrue((this.service.getVDBs().size() == 2 ? 1 : 0) != 0);
    }

    public void testSaveConnectorBinding() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        String msg = "Test update of the connector binding";
        BasicConnectorBinding binding = (BasicConnectorBinding)this.service.getConnectorBinding("QT_ORA9DS_1.BQT2 Oracle 9i Simple Cap");
        binding.setDescription(msg);
        this.service.saveConnectorBinding(binding.getFullName(), (ConnectorBinding)binding);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        BasicVDBDefn def = vdb.getConfigurationDef();
        Map bindings = def.getConnectorBindings();
        ConnectorBinding savedBinding = (ConnectorBinding)bindings.get("BQT2 Oracle 9i Simple Cap");
        TestEmbeddedConfigurationService.assertEquals((String)msg, (String)savedBinding.getDescription());
        Collection configBindings = this.service.getSystemConfiguration().getConfiguration().getConnectorBindings();
        for (ConnectorBinding b : configBindings) {
            if (!b.getFullName().equals("BQT2 Oracle 9i Simple Cap")) continue;
            TestEmbeddedConfigurationService.assertEquals((String)msg, (String)b.getDescription());
        }
    }

    public void testSaveConnectorType() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        String msg = "Test update of the connector type";
        BasicConnectorBindingType type = (BasicConnectorBindingType)this.service.getConnectorType("File XMLSource Connector");
        type.setDescription(msg);
        this.service.saveConnectorType((ConnectorBindingType)type);
        TestEmbeddedConfigurationService.assertEquals((String)msg, (String)this.service.getConnectorType("File XMLSource Connector").getDescription());
        Collection componentTypes = this.service.getSystemConfiguration().getComponentTypes().values();
        for (ComponentType t : componentTypes) {
            if (t.getComponentTypeCode() != 2 || !t.getFullName().equals("File XMLSource Connector")) continue;
            TestEmbeddedConfigurationService.assertEquals((String)msg, (String)t.getDescription());
        }
    }

    public void testSaveVDB() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        VDBArchive vdb = this.service.getVDB("QT_Ora9DS", "1");
        this.service.saveVDB(vdb, "NEXT_VDB_VERSION");
        TestEmbeddedConfigurationService.assertEquals((String)"QT_Ora9DS", (String)vdb.getName());
        TestEmbeddedConfigurationService.assertEquals((String)"2", (String)vdb.getVersion());
        TestEmbeddedConfigurationService.assertNotNull((Object)this.service.getVDB("QT_Ora9DS", "2"));
    }

    public void testGetProcessorBatchSize() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertEquals((String)"3867", (String)this.service.getProcessorBatchSize());
    }

    public void testGetConnectorBatchSize() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertEquals((String)"3868", (String)this.service.getConnectorBatchSize());
    }

    public void testLoadedConnectorBindings() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertEquals((String)"There shlould be only three connectors", (int)3, (int)this.service.getConnectorBindings().size());
        for (ConnectorBinding binding : this.service.getConnectorBindings()) {
            TestEmbeddedConfigurationService.assertTrue(("QT_ORA9DS_1.BQT1 Oracle 9i Simple Cap|QT_ORA9DS_1.BQT2 Oracle 9i Simple Cap".indexOf(binding.getDeployedName()) != -1 ? 1 : 0) != 0);
        }
        int count = 0;
        for (String binding : this.service.loadedConnectorBindings.keySet()) {
            if (!binding.startsWith("QT_ORA9DS_1.")) continue;
            ++count;
        }
        TestEmbeddedConfigurationService.assertEquals((int)2, (int)count);
    }

    public void testAddConnectorBinding() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        ConnectorBinding binding = this.service.getConnectorBinding("QT_ORA9DS_1.BQT1 Oracle 9i Simple Cap");
        TestEmbeddedConfigurationService.assertNotNull((Object)binding);
        List vdbs = this.service.getVdbsThatUseConnectorBinding(binding.getDeployedName());
        TestEmbeddedConfigurationService.assertEquals((int)1, (int)vdbs.size());
        TestEmbeddedConfigurationService.assertEquals((String)"QT_Ora9DS", (String)((VDBArchive)vdbs.get(0)).getName());
    }

    public void testGetConnectorTypes() throws Exception {
        Properties p;
        this.service.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.service.initializeService(p);
        TestEmbeddedConfigurationService.assertEquals((int)23, (int)this.service.loadedConnectorTypes.size());
    }
}

