/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.Application;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.core.util.UnitTestUtil;
import com.metamatrix.dqp.embedded.EmbeddedTestUtil;
import com.metamatrix.dqp.embedded.configuration.ConnectorConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.dqp.embedded.services.EmbeddedConfigurationService;
import com.metamatrix.dqp.embedded.services.EmbeddedVDBService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TestEmbeddedVDBService
extends TestCase {
    EmbeddedConfigurationService configService = null;
    EmbeddedVDBService vdbService = null;

    protected void setUp() throws Exception {
        EmbeddedTestUtil.createTestDirectory();
        Application registry = new Application();
        this.configService = new EmbeddedConfigurationService();
        registry.installService("dqp.configuration", (ApplicationService)this.configService);
        this.vdbService = new EmbeddedVDBService();
        registry.installService("dqp.vdb", (ApplicationService)this.vdbService);
    }

    protected void tearDown() throws Exception {
        this.vdbService.stop();
        this.configService.stop();
    }

    public void testGetTestVDB() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        VDBArchive vdb = this.vdbService.getVDB("QT_Ora9DS", "1");
        TestEmbeddedVDBService.assertEquals((String)"QT_Ora9DS", (String)vdb.getName());
        TestEmbeddedVDBService.assertEquals((String)"1", (String)vdb.getVersion());
        try {
            vdb = this.vdbService.getVDB("Foo", "1");
            TestEmbeddedVDBService.fail((String)"must have thrown a exception");
        }
        catch (MetaMatrixComponentException metaMatrixComponentException) {
            // empty catch block
        }
    }

    public void testSystemModelConnectorBinding() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        List names = this.vdbService.getConnectorBindingNames("QT_Ora9DS", "1", "SystemPhysical");
        TestEmbeddedVDBService.assertEquals((int)1, (int)names.size());
        TestEmbeddedVDBService.assertEquals((String)"SystemPhysical", (String)((String)names.get(0)));
    }

    public void testGetConnectorBindingNames() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        List names = this.vdbService.getConnectorBindingNames("QT_Ora9DS", "1", "BQT1");
        TestEmbeddedVDBService.assertEquals((int)1, (int)names.size());
        TestEmbeddedVDBService.assertEquals((String)"QT_ORA9DS_1.BQT1 Oracle 9i Simple Cap", (String)((String)names.get(0)));
    }

    public void testMapConnectorBinding() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        Properties props = new Properties();
        props.setProperty("MaxResultRows", "10000");
        props.setProperty("ConnectorThreadTTL", "120000");
        props.setProperty("ConnectorMaxThreads", "5");
        props.setProperty("metamatrix.service.essentialservice", "false");
        props.setProperty("ConnectorClassPath", "extensionjar:loopbackconn.jar;extensionjar:jdbcconn.jar");
        props.setProperty("RowCount", "12");
        props.setProperty("ServiceClassName", "com.metamatrix.server.connector.service.ConnectorService");
        props.setProperty("ConnectorClass", "com.metamatrix.connector.loopback.LoopbackConnector");
        props.setProperty("WaitTime", "0");
        props.setProperty("DeployedName", "Loopy");
        ConnectorBindingType ctype = this.configService.getConnectorType("Loopback Connector");
        ConnectorBinding binding = ConnectorConfigurationReader.loadConnectorBinding((String)"Loopy", (Properties)props, (ConnectorBindingType)ctype);
        ArrayList<ConnectorBinding> list = new ArrayList<ConnectorBinding>();
        list.add(binding);
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.configService.getConnectorBindings().size());
        VDBArchive vdb = this.vdbService.getVDB("QT_Ora9DS", "1");
        TestEmbeddedVDBService.assertEquals((int)2, (int)vdb.getConfigurationDef().getConnectorBindings().size());
        this.configService.assignConnectorBinding("QT_Ora9DS", "1", "BQT1", list.toArray(new ConnectorBinding[list.size()]));
        vdb = this.vdbService.getVDB("QT_Ora9DS", "1");
        TestEmbeddedVDBService.assertEquals((int)2, (int)vdb.getConfigurationDef().getConnectorBindings().size());
        List names = this.vdbService.getConnectorBindingNames("QT_Ora9DS", "1", "BQT1");
        TestEmbeddedVDBService.assertEquals((int)1, (int)names.size());
        TestEmbeddedVDBService.assertEquals((String)"Loopy", (String)((String)names.get(0)));
        this.vdbService.stopService();
        this.configService.stopService();
        Application registry = new Application();
        this.configService = new EmbeddedConfigurationService();
        this.configService.userPreferences = p;
        this.configService.initializeService(p);
        registry.installService("dqp.configuration", (ApplicationService)this.configService);
        this.vdbService = new EmbeddedVDBService();
        registry.installService("dqp.vdb", (ApplicationService)this.vdbService);
        names = this.vdbService.getConnectorBindingNames("QT_Ora9DS", "1", "BQT1");
        TestEmbeddedVDBService.assertEquals((int)1, (int)names.size());
        TestEmbeddedVDBService.assertEquals((String)"Loopy", (String)((String)names.get(0)));
        this.configService.stopService();
    }

    public void testVDBResource() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertNotNull((Object)this.vdbService.getVDBResource("Admin", "1"));
    }

    public void testAvailableVDBs() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        List vdbs = this.vdbService.getAvailableVDBs();
        for (VDBArchive vdb : vdbs) {
            TestEmbeddedVDBService.assertTrue(("QT_Ora9DS|Admin".indexOf(vdb.getName()) != -1 ? 1 : 0) != 0);
        }
    }

    public void testDeployNewVDB() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.configService.getConnectorBindings().size());
        File f = new File(UnitTestUtil.getTestDataPath() + "/dqp/TestEmpty.vdb");
        VDBArchive vdb = VDBConfigurationReader.loadVDB((URL)f.toURL());
        this.configService.addVDB(vdb, true);
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.vdbService.getAvailableVDBs().size());
        vdb = this.vdbService.getVDB("TestEmpty", "1");
        TestEmbeddedVDBService.assertEquals((String)"TestEmpty", (String)vdb.getName());
        TestEmbeddedVDBService.assertEquals((String)"1", (String)vdb.getVersion());
        TestEmbeddedVDBService.assertEquals((int)4, (int)this.configService.getConnectorBindings().size());
    }

    public void testDeploySameVDB() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.configService.getConnectorBindings().size());
        File f = new File(UnitTestUtil.getTestDataPath() + "/dqp/config/QT_Ora9DS.vdb");
        VDBArchive vdb = VDBConfigurationReader.loadVDB((URL)f.toURL());
        this.configService.addVDB(vdb, true);
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.vdbService.getAvailableVDBs().size());
        vdb = this.vdbService.getVDB("QT_Ora9DS", "2");
        TestEmbeddedVDBService.assertEquals((String)"QT_Ora9DS", (String)vdb.getName());
        TestEmbeddedVDBService.assertEquals((String)"2", (String)vdb.getVersion());
        TestEmbeddedVDBService.assertEquals((int)3, (int)this.configService.getConnectorBindings().size());
    }

    public void changeVDBStatus_delete() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        this.vdbService.changeVDBStatus("QT_Ora9DS", "1", 4);
        TestEmbeddedVDBService.assertEquals((int)1, (int)this.vdbService.getAvailableVDBs().size());
    }

    public void changeVDBStatus_inactive() throws Exception {
        Properties p;
        this.configService.userPreferences = p = EmbeddedTestUtil.getProperties();
        this.configService.initializeService(p);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        this.vdbService.changeVDBStatus("QT_Ora9DS", "1", 2);
        TestEmbeddedVDBService.assertEquals((int)2, (int)this.vdbService.getAvailableVDBs().size());
        VDBArchive vdb = this.vdbService.getVDB("QT_Ora9DS", "1");
        TestEmbeddedVDBService.assertEquals((short)2, (short)vdb.getStatus());
    }
}

